/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.validation.database;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.opensingular.lib.support.persistence.SimpleDAO;
import org.opensingular.server.commons.admin.healthsystem.validation.database.IValidatorDatabase;
import org.opensingular.server.commons.persistence.dto.healthsystem.ColumnInfoDTO;
import org.opensingular.server.commons.persistence.dto.healthsystem.SequenceInfoDTO;
import org.opensingular.server.commons.persistence.dto.healthsystem.TableInfoDTO;

@Named
public abstract class AbstractValidator
extends SimpleDAO
implements IValidatorDatabase {
    @Override
    @Transactional
    public List<TableInfoDTO> getAllInfoTable(List<String> table) {
        ArrayList<TableInfoDTO> privileges = new ArrayList<TableInfoDTO>();
        table.forEach(tableName -> {
            TableInfoDTO tableInfo = new TableInfoDTO();
            tableInfo.setTableName((String)tableName);
            tableInfo.setUserPrivs(this.getPermissionSpecificTable((String)tableName));
            privileges.add(tableInfo);
            if (!tableInfo.getUserPrivs().isEmpty()) {
                tableInfo.setColumnsInfo(this.getColumnsInfoFromTable((String)tableName));
                if (tableInfo.getColumnsInfo() != null && !tableInfo.getColumnsInfo().isEmpty()) {
                    tableInfo.setSchema(tableInfo.getColumnsInfo().get(0).getSchema());
                }
            }
        });
        return privileges;
    }

    @Override
    @Transactional
    public void checkColumnPermissions(TableInfoDTO tableInfoDTO) {
        List<ColumnInfoDTO> columns = this.getColumnsInfoFromTable(tableInfoDTO.getTableName());
        columns.forEach(column -> {
            boolean databaseColumnFoundInHibernate = false;
            for (ColumnInfoDTO col : tableInfoDTO.getColumnsInfo()) {
                if (!col.getColumnName().equals(column.getColumnName())) continue;
                databaseColumnFoundInHibernate = true;
                column.setFoundHibernate(true);
                break;
            }
            if (!databaseColumnFoundInHibernate) {
                column.setFoundHibernate(false);
            }
        });
        tableInfoDTO.getColumnsInfo().forEach(tableCol -> {
            boolean hibernateColumnFoundInDatabase = false;
            for (ColumnInfoDTO col : columns) {
                if (!col.getColumnName().equals(tableCol.getColumnName())) continue;
                hibernateColumnFoundInDatabase = true;
                break;
            }
            if (!hibernateColumnFoundInDatabase) {
                tableCol.setFoundHibernate(true);
                tableCol.setFoundDataBase(false);
                columns.add((ColumnInfoDTO)tableCol);
            }
        });
        tableInfoDTO.setColumnsInfo(columns);
    }

    protected abstract List<ColumnInfoDTO> getColumnsInfoFromTable(String var1);

    protected abstract List<String> getPermissionSpecificTable(String var1);

    @Override
    @Transactional
    public List<TableInfoDTO> getTablesPermission(List<TableInfoDTO> tables) {
        tables.forEach(table -> this.setFoundAndUserPermissionFromTable((TableInfoDTO)table));
        return tables;
    }

    private void setFoundAndUserPermissionFromTable(TableInfoDTO table) {
        List<String> permissions = this.getPermissionSpecificTable(table.getTableName());
        table.setUserPrivs(permissions);
        if (permissions != null && !permissions.isEmpty()) {
            table.setFound(true);
        } else {
            table.setFound(false);
        }
    }

    @Override
    @Transactional
    public List<SequenceInfoDTO> checkSequences(List<String> sequencesName) {
        ArrayList<SequenceInfoDTO> sequences = new ArrayList<SequenceInfoDTO>();
        sequencesName.forEach(sequenceName -> {
            SequenceInfoDTO info = this.getSequenceInfoDTO((String)sequenceName);
            if (info == null) {
                info = new SequenceInfoDTO();
                info.setSequenceName((String)sequenceName);
                info.setFound(false);
            }
            sequences.add(info);
        });
        return sequences;
    }

    protected abstract SequenceInfoDTO getSequenceInfoDTO(String var1);

    @Override
    @Transactional
    public void checkAllInfoTable(List<TableInfoDTO> tables) {
        tables.forEach(table -> {
            this.setFoundAndUserPermissionFromTable((TableInfoDTO)table);
            this.checkColumnPermissions((TableInfoDTO)table);
            if (table.getSchema() == null && table.getColumnsInfo() != null && !table.getColumnsInfo().isEmpty()) {
                table.setSchema(table.getColumnsInfo().get(0).getSchema());
            }
        });
    }
}

