/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.validation.database;

import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.opensingular.server.commons.admin.healthsystem.validation.database.IValidatorDatabase;
import org.opensingular.server.commons.admin.healthsystem.validation.database.ValidatorOracle;
import org.opensingular.server.commons.exception.SingularServerException;

public enum ValidatorFactory {
    ORACLE("Oracle"){

        @Override
        public IValidatorDatabase getValidator() {
            return (IValidatorDatabase)ApplicationContextProvider.get().getBean(ValidatorOracle.class);
        }
    };

    private String description;

    public abstract IValidatorDatabase getValidator();

    private ValidatorFactory(String description) {
        this.description = description;
    }

    public static IValidatorDatabase getValidator(String driverDialect) {
        for (ValidatorFactory value : ValidatorFactory.values()) {
            if (!driverDialect.contains(value.description)) continue;
            return value.getValidator();
        }
        throw new SingularServerException("Validator n\u00e3o encontrado");
    }
}

