/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.validation.database;

import java.math.BigDecimal;
import java.util.List;
import javax.inject.Named;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.opensingular.server.commons.admin.healthsystem.validation.database.AbstractValidator;
import org.opensingular.server.commons.persistence.dto.healthsystem.ColumnInfoDTO;
import org.opensingular.server.commons.persistence.dto.healthsystem.SequenceInfoDTO;

@Named
public class ValidatorOracle
extends AbstractValidator {
    @Override
    protected List<ColumnInfoDTO> getColumnsInfoFromTable(String table) {
        String query = "SELECT OWNER, COLUMN_NAME, DATA_TYPE, CHAR_LENGTH, DATA_PRECISION, TABLE_NAME, DATA_LENGTH, NULLABLE  FROM SYS.ALL_TAB_COLS  WHERE TABLE_NAME = :nome_tabela";
        SQLQuery querySQL = this.getSession().createSQLQuery(query);
        querySQL.setParameter("nome_tabela", (Object)table);
        querySQL.setResultTransformer(new ResultTransformer(){

            public Object transformTuple(Object[] obj, String[] arg1) {
                ColumnInfoDTO column = new ColumnInfoDTO();
                int i = 0;
                column.setSchema((String)obj[i]);
                column.setColumnName((String)obj[++i]);
                column.setDataType((String)obj[++i]);
                column.setCharLength((BigDecimal)obj[++i]);
                column.setDataPrecision((BigDecimal)obj[++i]);
                column.setTableName((String)obj[++i]);
                column.setDataLength((BigDecimal)obj[++i]);
                column.setNullable("Y".equals((String)obj[++i]));
                column.setFoundDataBase(true);
                return column;
            }

            public List transformList(List list) {
                return list;
            }
        });
        return querySQL.list();
    }

    @Override
    protected List<String> getPermissionSpecificTable(String table) {
        String query = " SELECT PRIVILEGE FROM SYS.ALL_TAB_PRIVS_RECD WHERE TABLE_NAME = :nome_tabela";
        SQLQuery querySQL = this.getSession().createSQLQuery(query);
        querySQL.setParameter("nome_tabela", (Object)table);
        return querySQL.list();
    }

    @Override
    protected SequenceInfoDTO getSequenceInfoDTO(String sequenceName) {
        String query = "SELECT  seq.SEQUENCE_NAME, seq.LAST_NUMBER, seq.MIN_VALUE, seq.MAX_VALUE, seq.INCREMENT_BY  FROM SYS.ALL_SEQUENCES seq   WHERE seq.SEQUENCE_NAME = :sequence_name";
        SQLQuery querySQL = this.getSession().createSQLQuery(query);
        querySQL.setParameter("sequence_name", (Object)sequenceName);
        querySQL.setResultTransformer(new ResultTransformer(){

            public Object transformTuple(Object[] arg0, String[] arg1) {
                SequenceInfoDTO info = new SequenceInfoDTO();
                int i = 0;
                info.setSequenceName((String)arg0[i]);
                info.setCurrentValue((BigDecimal)arg0[++i]);
                info.setMinValue((BigDecimal)arg0[++i]);
                info.setMaxValue((BigDecimal)arg0[++i]);
                info.setIncrement((BigDecimal)arg0[++i]);
                info.setFound(true);
                return info;
            }

            public List transformList(List list) {
                return list;
            }
        });
        return (SequenceInfoDTO)querySQL.uniqueResult();
    }
}

