/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.validation.webchecker;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensingular.server.commons.admin.healthsystem.validation.webchecker.HttpChecker;
import org.opensingular.server.commons.admin.healthsystem.validation.webchecker.IProtocolChecker;
import org.opensingular.server.commons.admin.healthsystem.validation.webchecker.IpChecker;
import org.opensingular.server.commons.admin.healthsystem.validation.webchecker.LdapChecker;
import org.opensingular.server.commons.admin.healthsystem.validation.webchecker.TcpChecker;
import org.opensingular.server.commons.exception.SingularServerException;

public enum ProtocolCheckerFactory {
    IP{

        @Override
        public IProtocolChecker checker() {
            return new IpChecker();
        }
    }
    ,
    TCP{

        @Override
        public IProtocolChecker checker() {
            return new TcpChecker();
        }
    }
    ,
    HTTP{

        @Override
        public IProtocolChecker checker() {
            return new HttpChecker();
        }
    }
    ,
    HTTPS{

        @Override
        public IProtocolChecker checker() {
            return new HttpChecker();
        }
    }
    ,
    LDAP{

        @Override
        public IProtocolChecker checker() {
            return new LdapChecker();
        }
    }
    ,
    LDAPS{

        @Override
        public IProtocolChecker checker() {
            return new LdapChecker();
        }
    };


    public static IProtocolChecker getProtocolChecker(String url) {
        for (ProtocolCheckerFactory checkerFactory : ProtocolCheckerFactory.values()) {
            Pattern pattern = Pattern.compile("^(?i)" + (Object)((Object)checkerFactory) + "(?i)");
            Matcher matcher = pattern.matcher(url);
            if (!matcher.find()) continue;
            return checkerFactory.checker();
        }
        throw new SingularServerException(String.format("Protocolo n\u00e3o suportado na url: %s", url));
    }

    public abstract IProtocolChecker checker();
}

