/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.box;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opensingular.server.commons.box.BoxItemData;
import org.opensingular.server.commons.box.BoxItemDataImpl;
import org.opensingular.server.commons.service.dto.BoxItemAction;

public class BoxItemDataMap
extends LinkedHashMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BoxItemData boxItemData;

    public BoxItemDataMap(BoxItemData boxItemData) {
        this.boxItemData = boxItemData;
        this.putAll(((BoxItemDataImpl)boxItemData).getRawMap());
    }

    public Long getCod() {
        Object codRequirement = this.get("codRequirement");
        if (codRequirement instanceof Number) {
            return ((Number)codRequirement).longValue();
        }
        if (codRequirement instanceof String) {
            return Integer.valueOf((String)codRequirement).longValue();
        }
        return null;
    }

    public Integer getVersionStamp() {
        Object versionStamp = this.get("versionStamp");
        if (versionStamp instanceof Number) {
            return ((Number)versionStamp).intValue();
        }
        if (versionStamp instanceof String) {
            return Integer.valueOf((String)versionStamp);
        }
        return null;
    }

    public Long getFlowInstanceId() {
        Object flowInstanceId = this.get("flowInstanceId");
        if (flowInstanceId instanceof Number) {
            return ((Number)flowInstanceId).longValue();
        }
        if (flowInstanceId instanceof String) {
            return Integer.valueOf((String)flowInstanceId).longValue();
        }
        return null;
    }

    public String getProcessBeginDate() {
        Object processBeginDate = this.get("processBeginDate");
        if (processBeginDate != null) {
            return String.valueOf(processBeginDate);
        }
        return null;
    }

    public Map<String, BoxItemAction> getActionsMap() {
        LinkedHashMap<String, BoxItemAction> actionsMap = new LinkedHashMap<String, BoxItemAction>();
        for (BoxItemAction boxItemAction : this.boxItemData.getBoxItemActions()) {
            actionsMap.put(boxItemAction.getName(), boxItemAction);
        }
        return actionsMap;
    }

    public BoxItemAction getActionByName(String actionName) {
        return this.getActionsMap().get(actionName);
    }

    public boolean hasAction(BoxItemAction itemAction) {
        return this.getActionsMap().containsKey(itemAction.getName());
    }
}

