/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.opensingular.form.SType;
import org.opensingular.form.spring.SpringSDocumentFactory;
import org.opensingular.form.spring.SpringTypeLoader;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.opensingular.server.commons.form.SingularServerDocumentFactory;
import org.opensingular.server.commons.form.SingularServerFormConfigFactory;
import org.opensingular.server.commons.form.SingularServerSpringTypeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class FormInitializer {
    public static final Logger logger = LoggerFactory.getLogger(FormInitializer.class);
    static final String SINGULAR_FORM = "[SINGULAR][FORM] {}";
    private List<Class<? extends SType<?>>> types = null;

    protected Class<? extends SpringSDocumentFactory> documentFactory() {
        return SingularServerDocumentFactory.class;
    }

    protected Class<? extends SpringTypeLoader> typeLoader() {
        return SingularServerSpringTypeLoader.class;
    }

    protected Class<?> formConfigFactory() {
        return SingularServerFormConfigFactory.class;
    }

    protected synchronized List<Class<? extends SType<?>>> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList();
            SingularClassPathScanner.get().findSubclassesOf(SType.class).stream().filter(f -> !Modifier.isAbstract(f.getModifiers())).forEach(f -> this.types.add((Class<SType<?>>)f));
        }
        return this.types;
    }

    public void init(ServletContext ctx, AnnotationConfigWebApplicationContext applicationContext) {
        Class<? extends SpringSDocumentFactory> documentFactory = this.documentFactory();
        if (documentFactory != null) {
            applicationContext.register(new Class[]{documentFactory});
        } else {
            logger.info(SINGULAR_FORM, (Object)" Null Form Document Factory, skipping Form Document Factory configuration. ");
        }
        Class<? extends SpringTypeLoader> typeLoader = this.typeLoader();
        if (typeLoader != null) {
            applicationContext.register(new Class[]{typeLoader});
        } else {
            logger.info(SINGULAR_FORM, (Object)" Null Form Type Loader, skipping Form Type Loader configuration. ");
        }
        Class<?> formConfigFactory = this.formConfigFactory();
        if (formConfigFactory != null) {
            applicationContext.register(new Class[]{formConfigFactory});
        } else {
            logger.info(SINGULAR_FORM, (Object)" Null Form Config Factory, skipping Form Config Factory configuration. ");
        }
    }
}

