/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.request.Request;
import org.opensingular.server.commons.exception.SingularServerException;

public interface IServerContext
extends Serializable {
    public static IServerContext getContextFromRequest(Request request, IServerContext[] contexts) {
        return IServerContext.getContextFromRequest((HttpServletRequest)request.getContainerRequest(), contexts);
    }

    public static IServerContext getContextFromName(String name, IServerContext[] contexts) {
        for (IServerContext ctx : contexts) {
            if (!name.equals(ctx.getName())) continue;
            return ctx;
        }
        throw SingularServerException.rethrow("N\u00e3o foi poss\u00edvel determinar o contexto do servidor do singular");
    }

    public static IServerContext getContextFromRequest(HttpServletRequest request, IServerContext[] contexts) {
        String contextPath = request.getContextPath();
        String context = request.getPathInfo().replaceFirst(contextPath, "");
        for (IServerContext ctx : contexts) {
            if (!context.startsWith(ctx.getUrlPath())) continue;
            return ctx;
        }
        throw SingularServerException.rethrow("N\u00e3o foi poss\u00edvel determinar o contexto do servidor do singular");
    }

    default public String getServerPropertyKey(String basePropertyKey) {
        return this.getPropertiesBaseKey() + "." + basePropertyKey;
    }

    public String getContextPath();

    public String getPathRegex();

    public String getUrlPath();

    @Deprecated
    public String getPropertiesBaseKey();

    public String getName();

    default public boolean isSameContext(IServerContext context) {
        return context != null && this.getName().equals(context.getName());
    }
}

