/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import com.google.common.base.Joiner;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.config.PServerContext;
import org.opensingular.server.commons.config.WebInitializer;
import org.opensingular.server.commons.spring.security.config.cas.util.SSOFilter;

public abstract class PWebInitializer
extends WebInitializer {
    @Override
    public IServerContext[] serverContexts() {
        return new IServerContext[]{PServerContext.REQUIREMENT, PServerContext.WORKLIST, PServerContext.ADMINISTRATION};
    }

    @Override
    public void onStartup(ServletContext servletContext) throws ServletException {
        super.onStartup(servletContext);
        this.configureCAS(servletContext);
    }

    protected void configureCAS(ServletContext servletContext) {
        if (SingularProperties.get().isTrue("singular.cas.default.enabled")) {
            this.addCASFilter(servletContext, PServerContext.WORKLIST);
            this.addCASFilter(servletContext, PServerContext.REQUIREMENT);
            this.addSingleSignOutListener(servletContext);
        }
    }

    protected void addCASFilter(ServletContext servletContext, PServerContext context) {
        this.configureSSO(servletContext, "SSOFilter" + context.getName(), context);
    }

    protected void addSingleSignOutListener(ServletContext servletContext) {
        servletContext.addListener(SingleSignOutHttpSessionListener.class);
    }

    protected void configureSSO(ServletContext servletContext, String filterName, IServerContext context) {
        FilterRegistration.Dynamic ssoFilter = servletContext.addFilter(filterName, SSOFilter.class);
        servletContext.setAttribute(filterName, (Object)context);
        ssoFilter.setInitParameter("SSOFilterSingularContextAttribute", filterName);
        ssoFilter.setInitParameter("logoutUrl", context.getUrlPath() + "/logout");
        ssoFilter.setInitParameter("urlExcludePattern", this.getExcludeUrlRegex());
        ssoFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{context.getContextPath()});
    }

    protected final String getExcludeUrlRegex() {
        return Joiner.on((String)",").join((Object[])this.getDefaultPublicUrls()).replaceAll("\\*", ".*");
    }
}

