/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.server.commons.config.IServerContext;

public enum ServerContext implements IServerContext
{
    WORKLIST("/worklist/*", "singular.worklist");

    private final String propertiesBaseKey;
    private final String contextPath;

    private ServerContext(String defaultPath, String propertiesBaseKey) {
        this.propertiesBaseKey = propertiesBaseKey;
        String key = propertiesBaseKey + ".context";
        String path = SingularProperties.getOpt((String)key).orElse(null);
        if (path == null || path.length() <= 0) {
            path = defaultPath;
        }
        if (!path.endsWith("/*")) {
            path = path.endsWith("*") ? path.substring(0, path.length() - 2) + "/*" : (path.endsWith("/") ? path + "*" : path + "/*");
        }
        this.contextPath = path;
    }

    @Override
    public String getPropertiesBaseKey() {
        return this.propertiesBaseKey;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getPathRegex() {
        return this.getContextPath().replaceAll("\\*", ".*");
    }

    @Override
    public String getUrlPath() {
        String path = this.getContextPath().replace("*", "").replace(".", "").trim();
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }
}

