/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.SmartLifecycle;

public class ServerStartExecutorBean
implements SmartLifecycle {
    private volatile boolean isRunning = false;
    private List<Runnable> executaveis;

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable r) {
        r.run();
        this.isRunning = false;
    }

    public void start() {
        this.getExecutaveis().forEach(Runnable::run);
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getPhase() {
        return 1;
    }

    public void register(Runnable runnable) {
        this.getExecutaveis().add(runnable);
    }

    private List<Runnable> getExecutaveis() {
        if (this.executaveis == null) {
            this.executaveis = new ArrayList<Runnable>();
        }
        return this.executaveis;
    }
}

