/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.opensingular.lib.commons.context.SingularContextSetup;
import org.opensingular.server.commons.config.FlowInitializer;
import org.opensingular.server.commons.config.FormInitializer;
import org.opensingular.server.commons.config.PSingularInitializer;
import org.opensingular.server.commons.config.PSpringSecurityInitializer;
import org.opensingular.server.commons.config.PWebInitializer;
import org.opensingular.server.commons.config.SchedulerInitializer;
import org.opensingular.server.commons.config.ServerContext;
import org.opensingular.server.commons.config.SingularServerConfiguration;
import org.opensingular.server.commons.config.SingularServerInitializerProvider;
import org.opensingular.server.commons.config.SpringHibernateInitializer;
import org.opensingular.server.commons.config.WebInitializer;
import org.opensingular.server.commons.exception.SingularServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class SingularInitializer
implements WebApplicationInitializer {
    static Logger logger = LoggerFactory.getLogger(SingularInitializer.class);
    static String SINGULAR = "[SINGULAR] {}";
    static String SERVLET_ATTRIBUTE_WEB_CONFIGURATION = "Singular-webInitializer";
    static String SERVLET_ATTRIBUTE_SPRING_HIBERNATE_CONFIGURATION = "Singular-springHibernateInitializer";
    static String SERVLET_ATTRIBUTE_FORM_CONFIGURATION_CONFIGURATION = "Singular-formInitializer";
    static String SERVLET_ATTRIBUTE_FLOW_CONFIGURATION_CONFIGURATION = "Singular-flowInitializer";
    private PSingularInitializer singularInitializer;

    public SingularInitializer() {
        this(SingularServerInitializerProvider.get().retrieve());
    }

    public SingularInitializer(PSingularInitializer singularInitializer) {
        this.singularInitializer = singularInitializer;
    }

    public void onStartup(ServletContext ctx) throws ServletException {
        SingularContextSetup.reset();
        logger.info(SINGULAR, (Object)" Initializing Singular.... ");
        logger.info(SINGULAR, (Object)" Initializing WebConfiguration ");
        PWebInitializer webInitializer = this.singularInitializer.webConfiguration();
        if (webInitializer != null) {
            webInitializer.init(ctx);
        } else {
            logger.info(SINGULAR, (Object)" Null webInitializer, skipping web configuration");
        }
        logger.info(SINGULAR, (Object)" Initializing SpringHibernateConfiguration ");
        SpringHibernateInitializer springHibernateInitializer = this.singularInitializer.springHibernateConfiguration();
        if (springHibernateInitializer == null) {
            throw new SingularServerException("N\u00e3o foi possivel configurar o ApplicationContext");
        }
        AnnotationConfigWebApplicationContext applicationContext = springHibernateInitializer.init(ctx);
        logger.info(SINGULAR, (Object)" Initializing SpringSecurity ");
        PSpringSecurityInitializer springSecurityInitializer = this.singularInitializer.springSecurityConfiguration();
        if (springSecurityInitializer != null) {
            springSecurityInitializer.init(ctx, applicationContext, Optional.of(springHibernateInitializer).map(SpringHibernateInitializer::springMVCServletMapping).orElse(null), Optional.ofNullable(webInitializer).map(WebInitializer::serverContexts).orElse(ServerContext.values()));
        } else {
            logger.info(SINGULAR, (Object)" Null springSecurityInitializer, skipping Spring Security configuration");
        }
        logger.info(SINGULAR, (Object)" Initializing FormConfiguration ");
        FormInitializer formInitializer = this.singularInitializer.formConfiguration();
        if (formInitializer != null) {
            formInitializer.init(ctx, applicationContext);
        } else {
            logger.info(SINGULAR, (Object)" Null formInitializer, skipping Singular Form configuration");
        }
        logger.info(SINGULAR, (Object)" Initializing FlowConfiguration ");
        FlowInitializer flowInitializer = this.singularInitializer.flowConfiguration();
        if (flowInitializer != null) {
            flowInitializer.init(ctx, applicationContext);
        } else {
            logger.info(SINGULAR, (Object)" Null flowInitializer, skipping Singular Flow configuration");
        }
        logger.info(SINGULAR, (Object)" Initializing SchedulerConfiguration ");
        SchedulerInitializer schedulerInitializer = this.singularInitializer.schedulerConfiguration();
        if (schedulerInitializer != null) {
            schedulerInitializer.init(ctx, applicationContext);
        } else {
            logger.info(SINGULAR, (Object)" Null SchedulerInitializer, skipping Singular Scheduler configuration");
        }
        if (applicationContext != null) {
            applicationContext.register(new Class[]{SingularServerConfiguration.class});
            applicationContext.register(new Class[]{this.singularInitializer.getSingularSpringWebMVCConfig()});
            ctx.setAttribute(SERVLET_ATTRIBUTE_WEB_CONFIGURATION, (Object)webInitializer);
            ctx.setAttribute(SERVLET_ATTRIBUTE_SPRING_HIBERNATE_CONFIGURATION, (Object)springHibernateInitializer);
            ctx.setAttribute(SERVLET_ATTRIBUTE_FLOW_CONFIGURATION_CONFIGURATION, (Object)flowInitializer);
            ctx.setAttribute(SERVLET_ATTRIBUTE_FORM_CONFIGURATION_CONFIGURATION, (Object)formInitializer);
        }
    }
}

