/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.opensingular.form.SType;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.opensingular.server.commons.config.FlowInitializer;
import org.opensingular.server.commons.config.FormInitializer;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.config.SingularInitializer;
import org.opensingular.server.commons.config.SpringHibernateInitializer;
import org.opensingular.server.commons.config.WebInitializer;
import org.opensingular.server.commons.flow.builder.RequirementFlowDefinition;
import org.springframework.web.context.ServletContextAware;

public class SingularServerConfiguration
implements ServletContextAware {
    private IServerContext[] contexts;
    private String springMVCServletMapping;
    private Map<String, Object> attrs = new HashMap<String, Object>();
    private List<Class<? extends SType<?>>> formTypes;
    private String moduleCod;
    private String[] definitionsPackages;
    private String[] defaultPublicUrls;

    public String[] getDefaultPublicUrls() {
        return this.defaultPublicUrls;
    }

    public IServerContext[] getContexts() {
        return this.contexts;
    }

    public String getSpringMVCServletMapping() {
        return this.springMVCServletMapping;
    }

    public Object setAttribute(String name, Object value) {
        return this.attrs.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attrs.get(name);
    }

    public List<Class<? extends SType<?>>> getFormTypes() {
        if (this.formTypes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.formTypes);
    }

    public String getModuleCod() {
        return this.moduleCod;
    }

    public String[] getDefinitionsPackages() {
        return this.definitionsPackages;
    }

    public void setServletContext(ServletContext servletContext) {
        WebInitializer webInitializer = (WebInitializer)servletContext.getAttribute(SingularInitializer.SERVLET_ATTRIBUTE_WEB_CONFIGURATION);
        SpringHibernateInitializer springHibernateInitializer = (SpringHibernateInitializer)servletContext.getAttribute(SingularInitializer.SERVLET_ATTRIBUTE_SPRING_HIBERNATE_CONFIGURATION);
        FormInitializer formInitializer = (FormInitializer)servletContext.getAttribute(SingularInitializer.SERVLET_ATTRIBUTE_FORM_CONFIGURATION_CONFIGURATION);
        FlowInitializer flowInitializer = (FlowInitializer)servletContext.getAttribute(SingularInitializer.SERVLET_ATTRIBUTE_FLOW_CONFIGURATION_CONFIGURATION);
        this.contexts = webInitializer.serverContexts();
        this.defaultPublicUrls = webInitializer.getDefaultPublicUrls();
        this.springMVCServletMapping = springHibernateInitializer.springMVCServletMapping();
        Optional.ofNullable(formInitializer).ifPresent(fi -> {
            this.formTypes = fi.getTypes();
        });
        Optional.ofNullable(flowInitializer).ifPresent(fi -> {
            this.moduleCod = flowInitializer.moduleCod();
        });
        Set processes = SingularClassPathScanner.get().findSubclassesOf(RequirementFlowDefinition.class);
        this.initDefinitionsPackages(processes.stream());
    }

    private void initDefinitionsPackages(Stream<Class<? extends RequirementFlowDefinition>> stream) {
        this.definitionsPackages = stream.map(c -> c.getPackage().getName()).collect(Collectors.toSet()).toArray(new String[0]);
    }
}

