/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import org.opensingular.lib.commons.context.SingularContext;
import org.opensingular.lib.commons.context.SingularSingletonStrategy;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.opensingular.server.commons.config.PSingularInitializer;

public class SingularServerInitializerProvider {
    private PSingularInitializer singularInitializer;

    private SingularServerInitializerProvider() {
    }

    static SingularServerInitializerProvider get() {
        return (SingularServerInitializerProvider)((SingularSingletonStrategy)SingularContext.get()).singletonize(SingularServerInitializerProvider.class, SingularServerInitializerProvider::new);
    }

    public PSingularInitializer retrieve() {
        if (this.singularInitializer == null) {
            List<Class<? extends PSingularInitializer>> configs = this.findAllInstantiableConfigs();
            if (configs.isEmpty()) {
                throw new SingularServerInitializerProviderException("\u00c9 obrigatorio implementar a classe " + PSingularInitializer.class);
            }
            if (configs.size() > 1) {
                throw new SingularServerInitializerProviderException("N\u00e3o \u00e9 permitido possuir mais de uma implementa\u00e7\u00e3o de " + PSingularInitializer.class);
            }
            Class<? extends PSingularInitializer> configClass = configs.get(0);
            try {
                this.singularInitializer = configClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new SingularServerInitializerProviderException("N\u00e3o foi possivel criar uma nova instancia de " + configClass.getName(), ex);
            }
        }
        return this.singularInitializer;
    }

    private List<Class<? extends PSingularInitializer>> findAllInstantiableConfigs() {
        return SingularClassPathScanner.get().findSubclassesOf(PSingularInitializer.class).stream().filter(config -> !Modifier.isAbstract(config.getModifiers()) && !config.isInterface() && !config.isAnonymousClass()).collect(Collectors.toList());
    }

    private static class SingularServerInitializerProviderException
    extends RuntimeException {
        public SingularServerInitializerProviderException(String s) {
            super(s);
        }

        public SingularServerInitializerProviderException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

