/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.opensingular.server.commons.jackson.SingularObjectMapper;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@EnableWebMvc
public class SingularSpringWebMVCConfig
extends WebMvcConfigurerAdapter {
    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        super.extendMessageConverters(converters);
        for (HttpMessageConverter<?> messageConverter : converters) {
            if (!(messageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter m = (MappingJackson2HttpMessageConverter)messageConverter;
            m.setObjectMapper((ObjectMapper)new SingularObjectMapper());
        }
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/resources/**"}).addResourceLocations(new String[]{"/resources/"});
        registry.addResourceHandler(new String[]{"/index.html"}).addResourceLocations(new String[]{"/WEB-INF/view/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/index.html");
    }
}

