/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import java.util.EventListener;
import java.util.Optional;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.opensingular.lib.support.spring.util.SingularAnnotationConfigWebApplicationContext;
import org.opensingular.server.commons.spring.SingularDefaultBeanFactory;
import org.opensingular.server.commons.spring.SingularDefaultPersistenceConfiguration;
import org.opensingular.server.commons.spring.SingularServerSpringAppConfig;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class SpringHibernateInitializer {
    public static final String SPRING_MVC_DISPATCHER_SERVLET = "Spring MVC Dispatcher Servlet";

    protected AnnotationConfigWebApplicationContext newApplicationContext() {
        return new SingularAnnotationConfigWebApplicationContext();
    }

    public AnnotationConfigWebApplicationContext init(ServletContext ctx) {
        AnnotationConfigWebApplicationContext applicationContext = this.newApplicationContext();
        applicationContext.register(new Class[]{this.springConfigurationClass()});
        applicationContext.register(new Class[]{this.beanFactory()});
        Optional.ofNullable(this.persistenceConfiguration()).ifPresent(xva$0 -> applicationContext.register(new Class[]{xva$0}));
        this.addSpringContextListener(ctx, applicationContext);
        this.addSpringRequestContextListener(ctx, applicationContext);
        this.addSpringMVCServlet(ctx, applicationContext);
        return applicationContext;
    }

    protected void addSpringContextListener(ServletContext ctx, AnnotationConfigWebApplicationContext applicationContext) {
        ctx.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)applicationContext));
    }

    protected void addSpringRequestContextListener(ServletContext ctx, AnnotationConfigWebApplicationContext applicationContext) {
        ctx.addListener(RequestContextListener.class);
    }

    protected void addSpringMVCServlet(ServletContext ctx, AnnotationConfigWebApplicationContext applicationContext) {
        ServletRegistration.Dynamic dispatcher = ctx.addServlet(SPRING_MVC_DISPATCHER_SERVLET, (Servlet)new DispatcherServlet((WebApplicationContext)applicationContext));
        dispatcher.setLoadOnStartup(1);
        dispatcher.addMapping(new String[]{this.springMVCServletMapping()});
    }

    protected Class<? extends SingularServerSpringAppConfig> springConfigurationClass() {
        return SingularServerSpringAppConfig.class;
    }

    protected Class<? extends SingularDefaultBeanFactory> beanFactory() {
        return SingularDefaultBeanFactory.class;
    }

    protected Class<? extends SingularDefaultPersistenceConfiguration> persistenceConfiguration() {
        return SingularDefaultPersistenceConfiguration.class;
    }

    protected String springMVCServletMapping() {
        return "/*";
    }
}

