/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import org.opensingular.lib.support.spring.security.DefaultRestSecurity;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.spring.security.config.SingularLogoutFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public abstract class SpringSecurityInitializer {
    static final String SINGULAR_SECURITY = "[SINGULAR][SECURITY] {} {}";
    public static final Logger logger = LoggerFactory.getLogger(SpringSecurityInitializer.class);

    public void init(ServletContext ctx, AnnotationConfigWebApplicationContext applicationContext, String springMVCServletMapping, IServerContext[] serverContexts) {
        this.addRestSecurity(applicationContext);
        this.addSpringSecurityFilter(ctx, applicationContext, springMVCServletMapping);
        for (IServerContext context : serverContexts) {
            logger.info(SINGULAR_SECURITY, (Object)"Securing (Spring Security) context:", (Object)context.getContextPath());
            Class config = this.getSpringSecurityConfigClass(context);
            if (config == null) continue;
            applicationContext.register(new Class[]{config});
            this.addLogoutFilter(ctx, applicationContext, springMVCServletMapping, context);
        }
    }

    protected void addRestSecurity(AnnotationConfigWebApplicationContext applicationContext) {
        applicationContext.register(new Class[]{DefaultRestSecurity.class});
    }

    protected void addLogoutFilter(ServletContext ctx, AnnotationConfigWebApplicationContext applicationContext, String springMVCServletMapping, IServerContext context) {
        ctx.addFilter("singularLogoutFilter" + System.identityHashCode(context), SingularLogoutFilter.class).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{context.getUrlPath() + "/logout"});
    }

    protected void addSpringSecurityFilter(ServletContext ctx, AnnotationConfigWebApplicationContext applicationContext, String springMVCServletMapping) {
        ctx.addFilter("springSecurityFilterChain", DelegatingFilterProxy.class).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{springMVCServletMapping});
    }

    protected abstract <T extends WebSecurityConfigurerAdapter> Class<T> getSpringSecurityConfigClass(IServerContext var1);
}

