/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.config;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.wicket.protocol.http.WicketFilter;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.config.ServerContext;
import org.opensingular.server.commons.wicket.SingularServerApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.support.OpenSessionInViewFilter;

public abstract class WebInitializer {
    static final String SINGULAR_SECURITY = "[SINGULAR][WEB] {} {}";
    public static final Logger logger = LoggerFactory.getLogger(WebInitializer.class);

    public void init(ServletContext ctx) throws ServletException {
        this.onStartup(ctx);
    }

    protected void onStartup(ServletContext ctx) throws ServletException {
        this.addSessionListener(ctx);
        this.addOpenSessionInView(ctx);
        for (IServerContext context : this.serverContexts()) {
            logger.info(SINGULAR_SECURITY, (Object)"Setting up web context:", (Object)context.getContextPath());
            this.addWicketFilter(ctx, context);
        }
    }

    public IServerContext[] serverContexts() {
        return ServerContext.values();
    }

    protected void addWicketFilter(ServletContext ctx, IServerContext context) {
        FilterRegistration.Dynamic wicketFilter = ctx.addFilter(context.getName() + System.identityHashCode(context), WicketFilter.class);
        wicketFilter.setInitParameter("applicationClassName", this.getWicketApplicationClass(context).getName());
        wicketFilter.setInitParameter("filterMappingUrlPattern", context.getContextPath());
        wicketFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{context.getContextPath()});
    }

    protected abstract Class<? extends SingularServerApplication> getWicketApplicationClass(IServerContext var1);

    private void addOpenSessionInView(ServletContext servletContext) {
        FilterRegistration.Dynamic opensessioninview = servletContext.addFilter("opensessioninview", OpenSessionInViewFilter.class);
        opensessioninview.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
    }

    protected String[] getDefaultPublicUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add("/rest/*");
        urls.add("/resources/*");
        urls.add("/public/*");
        urls.add("/index.html");
        for (IServerContext ctx : this.serverContexts()) {
            urls.add(ctx.getUrlPath() + "/wicket/resource/*");
            urls.add(ctx.getUrlPath() + "/public/*");
        }
        return urls.toArray(new String[urls.size()]);
    }

    protected int getSessionTimeoutMinutes() {
        return 15;
    }

    protected final void addSessionListener(ServletContext servletContext) {
        servletContext.addListener((EventListener)new HttpSessionListener(){

            public void sessionCreated(HttpSessionEvent se) {
                se.getSession().setMaxInactiveInterval(60 * WebInitializer.this.getSessionTimeoutMinutes());
            }

            public void sessionDestroyed(HttpSessionEvent se) {
            }
        });
    }
}

