/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.connector;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.flow.persistence.entity.Actor;
import org.opensingular.flow.persistence.entity.ModuleEntity;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.WorkspaceConfigurationMetadata;
import org.opensingular.server.commons.box.BoxItemDataList;
import org.opensingular.server.commons.box.BoxItemDataMap;
import org.opensingular.server.commons.box.action.ActionRequest;
import org.opensingular.server.commons.box.action.ActionResponse;
import org.opensingular.server.commons.config.IServerContext;
import org.opensingular.server.commons.connector.ModuleDriver;
import org.opensingular.server.commons.persistence.filter.QuickFilter;
import org.opensingular.server.commons.service.dto.BoxItemAction;
import org.opensingular.server.commons.service.dto.ItemActionConfirmation;
import org.opensingular.server.commons.service.dto.ItemBox;
import org.opensingular.server.commons.spring.security.SingularUserDetails;
import org.opensingular.server.commons.wicket.SingularSession;
import org.springframework.web.client.RestTemplate;

public class RESTModuleDriver
implements ModuleDriver,
Loggable {
    @Inject
    private Provider<SingularUserDetails> singularUserDetails;

    private <T extends SingularUserDetails> T getUserDetails() {
        return (T)((SingularUserDetails)this.singularUserDetails.get());
    }

    private String getConnectionURL(ModuleEntity module) {
        String path = this.removeFlowPathIfExists(module.getConnectionURL());
        return path + "/rest/flow";
    }

    @Deprecated
    private String removeFlowPathIfExists(String path) {
        String flowPath = "/rest/flow";
        if (path.endsWith(flowPath)) {
            return path.replaceAll(flowPath, "");
        }
        return path;
    }

    @Override
    public WorkspaceConfigurationMetadata retrieveModuleWorkspace(ModuleEntity module, IServerContext serverContext) {
        RestTemplate restTemplate = new RestTemplate();
        String url = this.getConnectionURL(module) + "/workspace" + "?" + "menuContext" + "=" + serverContext.getName();
        Object userDetails = this.getUserDetails();
        if (userDetails != null) {
            url = url + "&user=" + userDetails.getUserPermissionKey();
        }
        return (WorkspaceConfigurationMetadata)restTemplate.getForObject(url, WorkspaceConfigurationMetadata.class, new Object[0]);
    }

    @Override
    public String countAll(ModuleEntity module, ItemBox box, List<String> flowNames, String loggedUser) {
        long qtd;
        String connectionURL = this.getConnectionURL(module);
        String url = connectionURL + box.getCountEndpoint();
        try {
            QuickFilter filter = new QuickFilter().withProcessesAbbreviation(flowNames).withRascunho(box.isShowDraft()).withEndedTasks(box.getEndedTasks()).withIdUsuarioLogado(loggedUser).withIdPessoa(SingularSession.get().getUserDetails().getUserId());
            qtd = (Long)new RestTemplate().postForObject(url, (Object)filter, Long.class, new Object[0]);
        }
        catch (Exception e) {
            this.getLogger().error("Erro ao acessar servi\u00e7o: " + url, (Throwable)e);
            qtd = 0L;
        }
        return String.valueOf(qtd);
    }

    @Override
    public long countFiltered(ModuleEntity module, ItemBox box, QuickFilter filter) {
        String connectionURL = this.getConnectionURL(module);
        String url = connectionURL + box.getCountEndpoint();
        try {
            return (Long)new RestTemplate().postForObject(url, (Object)filter, Long.class, new Object[0]);
        }
        catch (Exception e) {
            this.getLogger().error("Erro ao acessar servi\u00e7o: " + url, (Throwable)e);
            return 0L;
        }
    }

    @Override
    public List<BoxItemDataMap> searchFiltered(ModuleEntity module, ItemBox box, QuickFilter filter) {
        String connectionURL = this.getConnectionURL(module);
        String url = connectionURL + box.getSearchEndpoint();
        try {
            return ((BoxItemDataList)new RestTemplate().postForObject(url, (Object)filter, BoxItemDataList.class, new Object[0])).getBoxItemDataList().stream().map(BoxItemDataMap::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.getLogger().error("Erro ao acessar servi\u00e7o: " + url, (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Actor> findEligibleUsers(ModuleEntity module, BoxItemDataMap rowItemData, ItemActionConfirmation confirmAction) {
        String connectionURL = this.getConnectionURL(module);
        String url = connectionURL + "/box/search" + confirmAction.getSelectEndpoint();
        try {
            return Arrays.asList((Object[])new RestTemplate().postForObject(url, (Object)rowItemData, Actor[].class, new Object[0]));
        }
        catch (Exception e) {
            this.getLogger().error("Erro ao acessar servi\u00e7o: " + url, (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public ActionResponse executeAction(ModuleEntity moduleEntity, BoxItemAction itemAction, Map<String, String> params, ActionRequest actionRequest) {
        String url = this.getConnectionURL(moduleEntity) + itemAction.getEndpoint() + this.appendParameters(params);
        return (ActionResponse)new RestTemplate().postForObject(url, (Object)actionRequest, ActionResponse.class, new Object[0]);
    }

    @Override
    public String buildUrlToBeRedirected(BoxItemDataMap rowItemData, BoxItemAction rowAction, Map<String, String> params, String baseURI) {
        BoxItemAction action = rowItemData.getActionByName(rowAction.getName());
        String endpoint = StringUtils.trimToEmpty((String)action.getEndpoint());
        if (endpoint.startsWith("http")) {
            return endpoint;
        }
        return baseURI + endpoint + this.appendParameters(params);
    }

    private String appendParameters(Map<String, String> additionalParams) {
        StringBuilder paramsValue = new StringBuilder();
        if (!additionalParams.isEmpty()) {
            for (Map.Entry<String, String> entry : additionalParams.entrySet()) {
                paramsValue.append(String.format("&%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        return paramsValue.toString();
    }
}

