/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.server.commons.service.RequirementInstance;

public class SingularServerException
extends SingularException {
    public SingularServerException(@Nonnull String msg) {
        super(msg);
    }

    public SingularServerException(@Nonnull String msg, @Nullable RequirementInstance requirement) {
        super(msg);
        this.add(requirement);
    }

    protected SingularServerException(Throwable cause) {
        super(cause);
    }

    protected SingularServerException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public static SingularServerException rethrow(Throwable e) {
        return SingularServerException.rethrow(null, e);
    }

    @Deprecated
    public static SingularServerException rethrow(String message) {
        return SingularServerException.rethrow(message, null);
    }

    public static SingularServerException rethrow(String message, Throwable e) {
        if (e instanceof SingularServerException) {
            if (message == null) {
                return (SingularServerException)((Object)e);
            }
        } else {
            if (message == null) {
                return new SingularServerException(e);
            }
            if (e == null) {
                return new SingularServerException(message);
            }
        }
        return new SingularServerException(message, e);
    }

    @Nonnull
    public SingularServerException add(@Nullable RequirementInstance requirement) {
        if (requirement != null) {
            this.add("codRequirement", () -> requirement.getCod());
            this.add("requirementFlow", () -> requirement.getFlowDefinitionOpt().map(d -> d.getName()).orElse(null));
            this.add("requirementDescription", () -> requirement.getDescription());
        }
        return this;
    }
}

