/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.flow;

import com.google.common.base.Throwables;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxEdgeLabelLayout;
import com.mxgraph.layout.mxParallelEdgeLayout;
import com.mxgraph.layout.orthogonal.mxOrthogonalLayout;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.opensingular.flow.core.FlowDefinition;
import org.opensingular.flow.core.FlowMap;
import org.opensingular.flow.core.STask;
import org.opensingular.flow.core.STransition;
import org.opensingular.flow.core.renderer.ExecutionHistoryForRendering;
import org.opensingular.flow.core.renderer.IFlowRenderer;

public enum JGraphFlowRenderer implements IFlowRenderer
{
    INSTANCE;


    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public byte[] generatePng(@Nonnull FlowDefinition<?> definition, @Nullable ExecutionHistoryForRendering history) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.generatePng(definition, history, outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void generatePng(@Nonnull FlowDefinition<?> definition, @Nullable ExecutionHistoryForRendering history, @Nonnull OutputStream out) throws IOException {
        mxGraph graph = JGraphFlowRenderer.renderGraph(definition);
        BufferedImage img = mxCellRenderer.createBufferedImage((mxGraph)graph, null, (double)1.0, (Color)Color.WHITE, (boolean)false, null);
        ImageIO.write((RenderedImage)img, "png", out);
    }

    private static void style(mxGraph graph) {
        mxStylesheet foo = new mxStylesheet();
        HashMap<String, Object> stil = new HashMap<String, Object>();
        stil.put(mxConstants.STYLE_ROUNDED, Boolean.TRUE);
        stil.put(mxConstants.STYLE_EDGE, "orthogonalEdgeStyle");
        stil.put(mxConstants.STYLE_SHAPE, "connector");
        stil.put(mxConstants.STYLE_ENDARROW, "classic");
        stil.put(mxConstants.STYLE_ALIGN, "center");
        stil.put(mxConstants.STYLE_VERTICAL_LABEL_POSITION, "bottom");
        stil.put(mxConstants.STYLE_VERTICAL_ALIGN, "bottom");
        stil.put(mxConstants.STYLE_STROKECOLOR, "#6482B9");
        stil.put(mxConstants.STYLE_FONTCOLOR, "#446299");
        foo.setDefaultEdgeStyle(stil);
        JGraphFlowRenderer.addStyleIcon(foo, "TIMER", "timer.png");
        JGraphFlowRenderer.addStyleIcon(foo, "END", "terminate.png");
        JGraphFlowRenderer.addStyleIcon(foo, "MESSAGE", "message_intermediate.png");
        JGraphFlowRenderer.addStyleIcon(foo, "START", "start.png");
        JGraphFlowRenderer.addStyleIcon(foo, "JAVA", "gear.png");
        JGraphFlowRenderer.addStyleIcon(foo, "HUMAN", "pessoinha.png");
        graph.setStylesheet(foo);
    }

    private static void addStyleIcon(mxStylesheet foo, String styleName, String imageName) {
        HashMap<String, String> def = new HashMap<String, String>();
        def.put(mxConstants.STYLE_SEGMENT, "bottom");
        def.put(mxConstants.STYLE_VERTICAL_LABEL_POSITION, "bottom");
        def.put(mxConstants.STYLE_SHAPE, "image");
        def.put(mxConstants.STYLE_IMAGE, String.format("/%s/%s", JGraphFlowRenderer.class.getPackage().getName().replace('.', '/'), imageName));
        foo.putCellStyle(styleName, def);
    }

    private static mxGraph renderGraph(FlowDefinition<?> definition) {
        Iterator v;
        mxGraph graph = new mxGraph();
        Object parent = graph.getDefaultParent();
        JGraphFlowRenderer.style(graph);
        graph.getModel().beginUpdate();
        graph.setAutoSizeCells(true);
        FlowMap fluxo = definition.getFlowMap();
        HashMap<String, Object> mapaVertice = new HashMap<String, Object>();
        for (STask task : fluxo.getTasks()) {
            v = JGraphFlowRenderer.insertVertex(graph, task);
            mapaVertice.put(task.getAbbreviation(), v);
        }
        for (STask task : fluxo.getEndTasks()) {
            v = JGraphFlowRenderer.insertVertex(graph, task);
            mapaVertice.put(task.getAbbreviation(), v);
        }
        JGraphFlowRenderer.addStartTransition(graph, fluxo.getStart().getTask(), mapaVertice);
        for (STask task : fluxo.getTasks()) {
            for (STransition transition : task.getTransitions()) {
                JGraphFlowRenderer.createTransition(graph, transition, mapaVertice);
            }
        }
        mxHierarchicalLayout layout = new mxHierarchicalLayout(graph);
        layout.setOrientation(7);
        layout.setIntraCellSpacing(30.0);
        layout.setInterRankCellSpacing(50.0);
        layout.setDisableEdgeStyle(false);
        layout.execute(parent);
        mxParallelEdgeLayout layoutParalelo = new mxParallelEdgeLayout(graph);
        layoutParalelo.execute(parent);
        mxOrthogonalLayout mxOrthogonalLayout2 = new mxOrthogonalLayout(graph);
        mxOrthogonalLayout2.execute(parent);
        mxEdgeLabelLayout labelLayout = new mxEdgeLabelLayout(graph);
        labelLayout.execute(parent);
        graph.getModel().endUpdate();
        return graph;
    }

    private static void addStartTransition(mxGraph graph, STask<?> taskInicial, Map<String, Object> mapaVertice) {
        Object v = graph.insertVertex(graph.getDefaultParent(), null, null, 20.0, 20.0, 20.0, 20.0);
        JGraphFlowRenderer.setStyle(v, "START");
        Object destiny = mapaVertice.get(taskInicial.getAbbreviation());
        graph.insertEdge(graph.getDefaultParent(), null, null, v, destiny);
    }

    private static void createTransition(mxGraph graph, STransition transition, Map<String, Object> mapNodes) {
        Object origin = mapNodes.get(transition.getOrigin().getAbbreviation());
        Object destiny = mapNodes.get(transition.getDestination().getAbbreviation());
        String name = transition.getName();
        name = transition.getDestination().getName().equals(name) ? null : JGraphFlowRenderer.formatName(name);
        graph.insertEdge(graph.getDefaultParent(), null, (Object)name, origin, destiny);
    }

    private static Object insertVertex(mxGraph graph, STask<?> task) {
        Object v = graph.insertVertex(graph.getDefaultParent(), task.getAbbreviation(), (Object)JGraphFlowRenderer.formatName(task.getName()), 20.0, 20.0, 20.0, 20.0);
        graph.updateCellSize(v);
        if (task.isWait()) {
            JGraphFlowRenderer.setStyle(v, "TIMER");
        } else if (task.isEnd()) {
            JGraphFlowRenderer.setStyle(v, "END");
        } else if (task.isPeople()) {
            JGraphFlowRenderer.setStyle(v, "HUMAN");
        } else if (task.isJava()) {
            if (task.getName().startsWith("Notificar")) {
                JGraphFlowRenderer.setStyle(v, "MESSAGE");
            } else {
                JGraphFlowRenderer.setStyle(v, "JAVA");
            }
        }
        return v;
    }

    private static void setStyle(Object v, String style) {
        ((mxICell)v).setStyle(style);
    }

    private static String formatName(String name) {
        return name.replace(' ', '\n');
    }
}

