/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.flow;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.opensingular.flow.core.Flow;
import org.opensingular.flow.core.SingularFlowConfigurationBean;
import org.opensingular.flow.core.renderer.IFlowRenderer;
import org.opensingular.flow.persistence.util.HibernateSingularFlowConfigurationBean;
import org.opensingular.flow.schedule.IScheduleService;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.config.SingularServerConfiguration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SingularServerFlowConfigurationBean
extends HibernateSingularFlowConfigurationBean
implements Loggable {
    @Inject
    protected SingularServerConfiguration singularServerConfiguration;
    @Inject
    protected PlatformTransactionManager transactionManager;
    @Inject
    private IScheduleService scheduleService;
    @Inject
    private IFlowRenderer flowRenderer;

    @PostConstruct
    protected void postConstruct() {
        this.setModuleCod(this.singularServerConfiguration.getModuleCod());
        this.setDefinitionsPackages(this.singularServerConfiguration.getDefinitionsPackages());
        Flow.setConf((SingularFlowConfigurationBean)this, (boolean)true);
        this.initializeFlowDefinitionsDatabase();
    }

    public IFlowRenderer getFlowRenderer() {
        return this.flowRenderer;
    }

    protected IScheduleService getScheduleService() {
        return this.scheduleService;
    }

    @Transactional
    public void initializeFlowDefinitionsDatabase() {
        if (SingularProperties.get().isTrue("singular.flow.eager.load")) {
            new TransactionTemplate(this.transactionManager).execute(status -> {
                this.getLogger().info("INITIALIZING FLOW DEFINITIONS");
                this.getDefinitions().forEach(d -> {
                    try {
                        this.getLogger().info("INITIALIZING {}....", (Object)d.getName());
                        d.getEntityFlowVersion();
                    }
                    catch (Exception e) {
                        this.getLogger().error(e.getMessage(), (Throwable)e);
                    }
                });
                return null;
            });
        }
    }
}

