/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.flow.controllers;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opensingular.server.commons.box.action.ActionRequest;
import org.opensingular.server.commons.box.action.ActionResponse;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.spring.security.AuthorizationService;

public abstract class IController {
    @Inject
    private AuthorizationService authorizationService;

    public ActionResponse run(RequirementInstance requirement, ActionRequest actionRequest) {
        if (this.hasPermission(requirement, actionRequest)) {
            return this.execute(requirement, actionRequest);
        }
        return new ActionResponse("Voc\u00ea n\u00e3o tem permiss\u00e3o para executar esta a\u00e7\u00e3o.", false);
    }

    private boolean hasPermission(RequirementInstance requirement, ActionRequest actionRequest) {
        return this.authorizationService.hasPermission(requirement.getCod(), null, actionRequest.getIdUsuario(), actionRequest.getAction().getName());
    }

    protected abstract ActionResponse execute(@Nonnull RequirementInstance var1, ActionRequest var2);

    protected Type getType() {
        return Type.PROCESS;
    }

    protected static enum Type {
        PROCESS,
        FORM;

    }
}

