/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.form;

import java.util.Optional;
import java.util.function.Predicate;
import org.opensingular.flow.core.ITaskDefinition;
import org.opensingular.flow.core.TaskInstance;
import org.opensingular.form.SInstance;
import org.opensingular.server.commons.form.ExistsCurrentTaskPredicate;
import org.opensingular.server.commons.form.NoCurrentTaskPredicate;
import org.opensingular.server.commons.service.RequirementUtil;

public class CurrentTaskPredicate
implements Predicate<SInstance> {
    private final ITaskDefinition[] referenceTasks;
    private final boolean negate;
    private TaskInstance currentTask;

    public static CurrentTaskPredicate in(ITaskDefinition ... referenceTask) {
        return new CurrentTaskPredicate(false, referenceTask);
    }

    public static CurrentTaskPredicate notIn(ITaskDefinition ... referenceTask) {
        return new CurrentTaskPredicate(true, referenceTask);
    }

    public static CurrentTaskPredicate hasNoCurrentTask() {
        return new NoCurrentTaskPredicate();
    }

    public static CurrentTaskPredicate hasCurrentTask() {
        return new ExistsCurrentTaskPredicate();
    }

    public CurrentTaskPredicate(boolean negate, ITaskDefinition ... referenceTasks) {
        this.negate = negate;
        this.referenceTasks = referenceTasks;
    }

    @Override
    public boolean test(SInstance x) {
        this.updateCurrentTask(x);
        Boolean result = this.getCurrentTask().map(this::matchesReferenceTask).orElse(Boolean.FALSE);
        if (this.negate) {
            return result == false;
        }
        return result;
    }

    protected Optional<TaskInstance> getCurrentTask() {
        return Optional.ofNullable(this.currentTask);
    }

    private boolean matchesReferenceTask(TaskInstance t) {
        for (ITaskDefinition ref : this.referenceTasks) {
            if (!ref.getName().equalsIgnoreCase(t.getName())) continue;
            return true;
        }
        return false;
    }

    protected void updateCurrentTask(SInstance instance) {
        this.currentTask = RequirementUtil.getCurrentTaskEntity(instance).orElse(null);
    }
}

