/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.form;

import org.opensingular.form.wicket.enums.AnnotationMode;
import org.opensingular.form.wicket.enums.ViewMode;

public enum FormAction {
    FORM_ANALYSIS(1, ViewMode.READ_ONLY, AnnotationMode.EDIT),
    FORM_FILL(2, ViewMode.EDIT, AnnotationMode.NONE),
    FORM_VIEW(3, ViewMode.READ_ONLY, AnnotationMode.NONE),
    FORM_FILL_WITH_ANALYSIS(4, ViewMode.EDIT, AnnotationMode.READ_ONLY),
    FORM_ANALYSIS_VIEW(5, ViewMode.READ_ONLY, AnnotationMode.READ_ONLY),
    FORM_FILL_WITH_ANALYSIS_FILL(4, ViewMode.EDIT, AnnotationMode.EDIT);

    private Integer id;
    private ViewMode viewMode;
    private AnnotationMode annotationMode;

    private FormAction(Integer id, ViewMode viewMode, AnnotationMode annotationMode) {
        this.id = id;
        this.viewMode = viewMode;
        this.annotationMode = annotationMode;
    }

    public static FormAction getById(Integer id) {
        for (FormAction fa : FormAction.values()) {
            if (!fa.id.equals(id)) continue;
            return fa;
        }
        return null;
    }

    public Integer getId() {
        return this.id;
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public AnnotationMode getAnnotationMode() {
        return this.annotationMode;
    }

    public boolean isAnnotationModeEdit() {
        return AnnotationMode.EDIT == this.getAnnotationMode();
    }

    public boolean isAnnotationModeReadOnly() {
        return AnnotationMode.READ_ONLY == this.getAnnotationMode();
    }

    public boolean isViewModeEdit() {
        return ViewMode.EDIT == this.getViewMode();
    }

    public boolean isViewModeReadOnly() {
        return ViewMode.READ_ONLY == this.getViewMode();
    }
}

