/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.form;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.opensingular.form.SDictionary;
import org.opensingular.form.SFormUtil;
import org.opensingular.form.SType;
import org.opensingular.form.SingularFormException;
import org.opensingular.form.spring.SpringTypeLoader;
import org.opensingular.server.commons.config.SingularServerConfiguration;
import org.opensingular.server.commons.service.RequirementUtil;

public class SingularServerSpringTypeLoader
extends SpringTypeLoader<String> {
    private final Map<String, Supplier<SType<?>>> entries = new LinkedHashMap();
    @Inject
    private SingularServerConfiguration singularServerConfiguration;

    @PostConstruct
    private void init() {
        this.singularServerConfiguration.getFormTypes().forEach(this::add);
    }

    private void add(Class<? extends SType<?>> type) {
        String typeName = RequirementUtil.getTypeName(type);
        this.add(typeName, () -> {
            SDictionary d = SDictionary.create();
            d.loadPackage(SFormUtil.getTypePackage((Class)type));
            return d.getType(type);
        });
    }

    private void add(String typeName, Supplier<SType<?>> typeSupplier) {
        this.entries.put(typeName, typeSupplier);
    }

    protected Optional<SType<?>> loadTypeImpl(String typeId) {
        return Optional.ofNullable(this.entries.get(typeId)).map(Supplier::get);
    }

    public Optional<SType<?>> loadType(@Nonnull Class<? extends SType> typeClass) {
        String typeId = SFormUtil.getTypeName(typeClass);
        return this.loadTypeImpl(typeId);
    }

    public SType<?> loadTypeOrException(@Nonnull Class<? extends SType> typeClass) {
        Objects.requireNonNull(typeClass);
        return this.loadType(typeClass).orElseThrow(() -> new SingularFormException("N\u00e3o foi encontrado o tipo para a classe=" + typeClass));
    }
}

