/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SingularObjectMapper
extends ObjectMapper {
    public SingularObjectMapper() {
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Timestamp.class, (JsonSerializer)new TimestampSerializer());
        this.registerModule((Module)module);
    }

    public <T extends Serializable> List<Map<String, Serializable>> toStringSerializableMap(List<T> serializables) {
        return serializables.stream().map(task -> (Map)this.convertValue(task, Map.class)).collect(Collectors.toList());
    }

    private static class TimestampSerializer
    extends JsonSerializer<Timestamp> {
        private TimestampSerializer() {
        }

        public void serialize(Timestamp value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                gen.writeString(sdf.format(value));
            }
        }
    }
}

