/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.dao.flow;

import java.sql.PreparedStatement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.opensingular.flow.core.SUser;
import org.opensingular.flow.persistence.entity.Actor;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.support.persistence.BaseDAO;
import org.opensingular.lib.support.persistence.util.SqlUtil;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.persistence.transformer.FindActorByUserCodResultTransformer;

public class ActorDAO
extends BaseDAO<Actor, Integer> {
    public ActorDAO() {
        super(Actor.class);
    }

    public Actor retrieveByUserCod(String userName) {
        if (userName == null) {
            return null;
        }
        SQLQuery query = this.getSession().createSQLQuery("select a.CO_ATOR as \"cod\", a.CO_USUARIO as \"codUsuario\", a.NO_ATOR as \"nome\", a.DS_EMAIL as \"email\"  FROM DBSINGULAR.VW_ATOR a  WHERE UPPER(rtrim(ltrim(a.CO_USUARIO))) = :codUsuario");
        query.setParameter("codUsuario", (Object)userName.toUpperCase());
        query.setResultTransformer((ResultTransformer)new FindActorByUserCodResultTransformer());
        return (Actor)query.uniqueResult();
    }

    public SUser saveUserIfNeeded(SUser sUser) {
        if (sUser == null) {
            return null;
        }
        Integer cod = sUser.getCod();
        String codUsuario = sUser.getCodUsuario();
        return this.saveUserIfNeeded(cod, codUsuario).orElse(null);
    }

    public Optional<SUser> saveUserIfNeeded(@Nonnull String codUsuario) {
        return this.saveUserIfNeeded(null, Objects.requireNonNull(codUsuario));
    }

    private Optional<SUser> saveUserIfNeeded(Integer cod, String codUsuario) {
        SUser result = null;
        if (cod != null) {
            result = (SUser)this.getSession().createCriteria(Actor.class).add((Criterion)Restrictions.eq((String)"cod", (Object)cod)).uniqueResult();
        }
        if (result == null && codUsuario != null) {
            result = (SUser)this.getSession().createCriteria(Actor.class).add(Restrictions.ilike((String)"codUsuario", (Object)codUsuario)).uniqueResult();
        }
        if (result == null && cod == null) {
            if ("sequence".equals(SingularProperties.getOpt((String)"flow.persistence.hibernate.generator").orElse(null))) {
                this.getSession().doWork(connection -> {
                    String sql = SqlUtil.replaceSingularSchemaName((String)"insert into DBSINGULAR.TB_ATOR (CO_ATOR, CO_USUARIO) VALUES (DBSINGULAR.SQ_CO_ATOR.NEXTVAL, ? )");
                    PreparedStatement ps = connection.prepareStatement(sql);
                    ps.setString(1, codUsuario);
                    int returnVal = ps.executeUpdate();
                    System.out.println(returnVal);
                });
            } else {
                this.getSession().doWork(connection -> {
                    String sql = SqlUtil.replaceSingularSchemaName((String)"insert into DBSINGULAR.TB_ATOR (CO_USUARIO) VALUES (?)");
                    PreparedStatement ps = connection.prepareStatement(sql);
                    ps.setString(1, codUsuario);
                    ps.execute();
                });
            }
            this.getSession().flush();
            result = (SUser)this.getSession().createCriteria(Actor.class).add((Criterion)Restrictions.eq((String)"codUsuario", (Object)codUsuario)).uniqueResult();
            if (result == null) {
                throw SingularServerException.rethrow("Usu\u00e1rio que deveria ter sido criado n\u00e3o pode ser recuperado.");
            }
        }
        return Optional.ofNullable(result);
    }

    public List<Actor> listAllowedUsers(Integer taskInstanceId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT DISTINCT a.CO_ATOR AS \"cod\",");
        sql.append("   a.CO_USUARIO            AS \"codUsuario\",");
        sql.append("   UPPER(a.NO_ATOR)        AS \"nome\",");
        sql.append("   a.DS_EMAIL              AS \"email\"");
        sql.append(" FROM DBSINGULAR .VW_ATOR a");
        sql.append(" ORDER BY UPPER(a.NO_ATOR)");
        SQLQuery query = this.getSession().createSQLQuery(sql.toString());
        query.addScalar("cod", (Type)StandardBasicTypes.INTEGER);
        query.addScalar("codUsuario", (Type)StandardBasicTypes.STRING);
        query.addScalar("nome", (Type)StandardBasicTypes.STRING);
        query.addScalar("email", (Type)StandardBasicTypes.STRING);
        query.setResultTransformer(Transformers.aliasToBean(Actor.class));
        return query.list();
    }
}

