/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.dao.form;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.lib.support.persistence.BaseDAO;
import org.opensingular.server.commons.persistence.entity.form.FormRequirementEntity;

public class FormRequirementDAO
extends BaseDAO<FormRequirementEntity, Long> {
    public FormRequirementDAO() {
        super(FormRequirementEntity.class);
    }

    @Nonnull
    public Optional<FormRequirementEntity> findFormRequirementEntityByTypeName(@Nonnull Long requirementPK, @Nonnull String typeName) {
        return FormRequirementDAO.findUniqueResult(FormRequirementEntity.class, (Criteria)this.getSession().createCriteria(FormRequirementEntity.class).createAlias("form", "formEntity").createAlias("formEntity.formType", "formType").add((Criterion)Restrictions.eq((String)"requirement.cod", (Object)requirementPK)).add((Criterion)Restrictions.eq((String)"formType.abbreviation", (Object)typeName)));
    }

    public Optional<FormRequirementEntity> findFormRequirementEntityByTypeNameAndTask(@Nonnull Long requirementPK, @Nonnull String typeName, @Nonnull Integer taskDefinitionEntityPK) {
        return FormRequirementDAO.findUniqueResult(FormRequirementEntity.class, (Criteria)this.getSession().createCriteria(FormRequirementEntity.class).createAlias("form", "formEntity").createAlias("formEntity.formType", "formType").add((Criterion)Restrictions.eq((String)"requirement.cod", (Object)requirementPK)).add((Criterion)Restrictions.eq((String)"formType.abbreviation", (Object)typeName)).add((Criterion)Restrictions.eq((String)"taskDefinitionEntity.cod", (Object)taskDefinitionEntityPK)));
    }

    public Optional<FormRequirementEntity> findLastFormRequirementEntityByTypeName(@Nonnull Long requirementPK, @Nonnull String typeName) {
        return FormRequirementDAO.findUniqueResult(FormRequirementEntity.class, (Criteria)this.getSession().createCriteria(FormRequirementEntity.class).createAlias("form", "formEntity").createAlias("formEntity.formType", "formType").createAlias("formEntity.currentFormVersionEntity", "currentFormVersion").add((Criterion)Restrictions.eq((String)"requirement.cod", (Object)requirementPK)).add((Criterion)Restrictions.eq((String)"formType.abbreviation", (Object)typeName)).addOrder(Order.desc((String)"currentFormVersion.inclusionDate")));
    }

    @Nonnull
    public List<FormVersionEntity> findTwoLastFormVersions(@Nonnull Long codForm) {
        return this.getSession().createCriteria(FormVersionEntity.class).createAlias("formEntity", "formEntity").add((Criterion)Restrictions.eq((String)"formEntity.cod", (Object)codForm)).addOrder(Order.desc((String)"inclusionDate")).setMaxResults(2).list();
    }

    @Nonnull
    public Long countVersions(@Nonnull Long codForm) {
        return (Long)this.getSession().createCriteria(FormVersionEntity.class).createAlias("formEntity", "formEntity").add((Criterion)Restrictions.eq((String)"formEntity.cod", (Object)codForm)).setProjection((Projection)Projections.countDistinct((String)"cod")).setMaxResults(1).uniqueResult();
    }
}

