/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.dao.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hibernate.Query;
import org.opensingular.flow.persistence.entity.AbstractTaskInstanceEntity;
import org.opensingular.flow.persistence.entity.FlowDefinitionEntity;
import org.opensingular.flow.persistence.entity.FlowInstanceEntity;
import org.opensingular.flow.persistence.entity.FlowVersionEntity;
import org.opensingular.flow.persistence.entity.TaskInstanceEntity;
import org.opensingular.flow.persistence.entity.TaskVersionEntity;
import org.opensingular.form.SType;
import org.opensingular.lib.support.persistence.BaseDAO;
import org.opensingular.server.commons.persistence.dto.RequirementHistoryDTO;
import org.opensingular.server.commons.persistence.entity.form.FormVersionHistoryEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementContentHistoryEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.service.RequirementUtil;
import org.opensingular.server.commons.service.dto.BoxConfigurationData;
import org.opensingular.server.commons.service.dto.RequirementDefinitionDTO;
import org.opensingular.server.commons.wicket.view.template.MenuService;

public class RequirementContentHistoryDAO
extends BaseDAO<RequirementContentHistoryEntity, Long> {
    @Inject
    private Optional<MenuService> menuService;

    public RequirementContentHistoryDAO() {
        super(RequirementContentHistoryEntity.class);
    }

    public List<RequirementHistoryDTO> listRequirementContentHistoryByCodRequirement(RequirementEntity requirementEntity, String menu, boolean filter) {
        List tasks = this.getSession().createQuery("select task from RequirementEntity p  inner join p.flowInstanceEntity.tasks as task where p.cod = :codRequirement").setParameter("codRequirement", (Object)requirementEntity.getCod()).list();
        List histories = this.getSession().createQuery("select h from RequirementContentHistoryEntity h  where h.requirementEntity.cod = :codRequirement").setParameter("codRequirement", (Object)requirementEntity.getCod()).list();
        ArrayList requirementHistoryDTOS = new ArrayList();
        histories.forEach(history -> requirementHistoryDTOS.add(new RequirementHistoryDTO().setRequirementContentHistory((RequirementContentHistoryEntity)((Object)history)).setTask(history.getTaskInstanceEntity())));
        List requirementHistoryTaskCods = histories.stream().map(RequirementContentHistoryEntity::getTaskInstanceEntity).map(AbstractTaskInstanceEntity::getCod).collect(Collectors.toList());
        tasks.stream().filter(task -> !requirementHistoryTaskCods.contains(task.getCod())).forEach(task -> requirementHistoryDTOS.add(new RequirementHistoryDTO().setTask((TaskInstanceEntity)task)));
        BoxConfigurationData boxConfigurationMetadata = this.menuService.map(ms -> ms.getMenuByLabel(menu)).orElse(null);
        return requirementHistoryDTOS.stream().filter(p -> this.filterAllowedHistoryTasks((RequirementHistoryDTO)p, boxConfigurationMetadata, filter)).sorted((a, b) -> a.getTask().getBeginDate().compareTo(b.getTask().getBeginDate())).collect(Collectors.toList());
    }

    private boolean filterAllowedHistoryTasks(RequirementHistoryDTO requirementHistoryDTO, BoxConfigurationData boxConfigurationMetadata, boolean filter) {
        if (!filter) {
            return true;
        }
        FlowDefinitionEntity flowDefinition = (FlowDefinitionEntity)((FlowVersionEntity)((FlowInstanceEntity)requirementHistoryDTO.getTask().getFlowInstance()).getFlowVersion()).getFlowDefinition();
        RequirementDefinitionDTO processByAbbreviation = boxConfigurationMetadata.getProcessByAbbreviation(flowDefinition.getKey());
        return processByAbbreviation != null && processByAbbreviation.getAllowedHistoryTasks().contains(((TaskVersionEntity)requirementHistoryDTO.getTask().getTaskVersion()).getAbbreviation());
    }

    public Optional<FormVersionHistoryEntity> findLastByCodRequirementAndType(Class<? extends SType<?>> typeClass, Long cod) {
        return this.findLastByCodRequirementAndType(RequirementUtil.getTypeName(typeClass), cod);
    }

    public Optional<FormVersionHistoryEntity> findLastByCodRequirementAndType(String typeName, Long cod) {
        return RequirementContentHistoryDAO.findUniqueResult(FormVersionHistoryEntity.class, (Query)this.getSession().createQuery(" select fvhe from RequirementContentHistoryEntity p  inner join p.formVersionHistoryEntities  fvhe  inner join fvhe.formVersion fv   inner join fv.formEntity fe   inner join fe.formType ft   where ft.abbreviation = :typeName and p.requirementEntity.cod = :cod  order by p.historyDate desc ").setParameter("typeName", (Object)typeName).setParameter("cod", (Object)cod));
    }
}

