/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.dao.form;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.hibernate.HibernateQuery;
import com.querydsl.jpa.hibernate.HibernateQueryFactory;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.opensingular.flow.core.TaskType;
import org.opensingular.form.persistence.entity.FormAttachmentEntity;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.form.persistence.entity.QFormAttachmentEntity;
import org.opensingular.form.persistence.entity.QFormEntity;
import org.opensingular.form.persistence.entity.QFormTypeEntity;
import org.opensingular.form.persistence.entity.QFormVersionEntity;
import org.opensingular.lib.support.persistence.BaseDAO;
import org.opensingular.lib.support.persistence.enums.SimNao;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.persistence.context.RequirementSearchContext;
import org.opensingular.server.commons.persistence.entity.form.QDraftEntity;
import org.opensingular.server.commons.persistence.entity.form.QFormRequirementEntity;
import org.opensingular.server.commons.persistence.entity.form.QRequirementEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.persistence.filter.QuickFilter;
import org.opensingular.server.commons.persistence.query.RequirementSearchQuery;
import org.opensingular.server.commons.persistence.query.RequirementSearchQueryFactory;
import org.opensingular.server.commons.persistence.requirement.RequirementSearchExtender;
import org.opensingular.server.commons.spring.security.RequirementAuthMetadataDTO;
import org.opensingular.server.commons.spring.security.SingularPermission;

public class RequirementDAO<T extends RequirementEntity>
extends BaseDAO<T, Long> {
    public RequirementDAO() {
        super(RequirementEntity.class);
    }

    public RequirementDAO(Class<T> entityClass) {
        super(entityClass);
    }

    public List<T> list(String type) {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        criteria.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        return criteria.list();
    }

    public Long countQuickSearch(QuickFilter filter, List<SingularPermission> permissions, List<RequirementSearchExtender> extenders) {
        return this.countQuickSearch(new RequirementSearchContext(filter).setCount(Boolean.TRUE).setEvaluatePermissions(Boolean.TRUE).setExtenders(extenders).addPermissions(permissions));
    }

    public Long countQuickSearch(QuickFilter filter, List<RequirementSearchExtender> extenders) {
        return this.countQuickSearch(new RequirementSearchContext(filter).setExtenders(extenders).setCount(Boolean.TRUE));
    }

    private Long countQuickSearch(RequirementSearchContext query) {
        return (Long)this.makeRequirementSearchQuery(query).uniqueResult();
    }

    private Query makeRequirementSearchQuery(RequirementSearchContext ctx) {
        RequirementSearchQueryFactory searchQueryFactory = new RequirementSearchQueryFactory(ctx);
        RequirementSearchQuery requirementSearchQuery = searchQueryFactory.make(this.getSession());
        return requirementSearchQuery.toHibernateQuery(ctx.getCount());
    }

    public List<Map<String, Serializable>> quickSearchMap(QuickFilter filter, List<RequirementSearchExtender> extenders) {
        return this.quickSearchMap(new RequirementSearchContext(filter).setExtenders(extenders).setCount(Boolean.FALSE));
    }

    public List<Map<String, Serializable>> quickSearchMap(QuickFilter filter, List<SingularPermission> permissions, List<RequirementSearchExtender> extenders) {
        return this.quickSearchMap(new RequirementSearchContext(filter).setCount(Boolean.FALSE).setEvaluatePermissions(Boolean.TRUE).setExtenders(extenders).addPermissions(permissions));
    }

    private List<Map<String, Serializable>> quickSearchMap(RequirementSearchContext query) {
        return this.makeRequirementSearchQuery(query).setFirstResult(query.getQuickFilter().getFirst()).setMaxResults(query.getQuickFilter().getCount()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    public T findByFlowCodOrException(Integer cod) {
        return (T)((Object)((RequirementEntity)((Object)this.findByFlowCod(cod).orElseThrow(() -> new SingularServerException("N\u00e3o foi encontrado a peti\u00e7\u00e3o com flowInstanceEntity.cod=" + cod)))));
    }

    public Optional<T> findByFlowCod(Integer cod) {
        Objects.requireNonNull(cod);
        return RequirementDAO.findUniqueResult((Class)this.entityClass, (Criteria)this.getSession().createCriteria(this.entityClass).add((Criterion)Restrictions.eq((String)"flowInstanceEntity.cod", (Object)cod)));
    }

    public T findByFormEntity(FormEntity formEntity) {
        return (T)((Object)((RequirementEntity)((Object)this.getSession().createQuery(" select p from " + this.entityClass.getName() + " p inner join p.formRequirementEntities fpe where fpe.form = :form ").setParameter("form", (Object)formEntity).setMaxResults(1).uniqueResult())));
    }

    public void delete(T requirement) {
        this.findFormAttachmentByCodRequirement(((RequirementEntity)((Object)requirement)).getCod()).forEach(arg_0 -> ((Session)this.getSession()).delete(arg_0));
        ((RequirementEntity)((Object)requirement)).getFormRequirementEntities().forEach(formRequirementEntity -> {
            FormEntity formEntity = formRequirementEntity.getForm();
            if (formEntity == null && formRequirementEntity.getCurrentDraftEntity() != null) {
                formEntity = formRequirementEntity.getCurrentDraftEntity().getForm();
            }
            if (formEntity != null) {
                FormVersionEntity formVersionEntity = formEntity.getCurrentFormVersionEntity();
                this.getSession().delete((Object)formVersionEntity);
                formEntity.setCurrentFormVersionEntity(null);
            }
        });
        this.getSession().flush();
        super.delete(requirement);
    }

    public RequirementAuthMetadataDTO findRequirementAuthMetadata(Long requirementId) {
        StringBuilder query = new StringBuilder();
        query.append(" select distinct new ").append(RequirementAuthMetadataDTO.class.getName()).append("(ft.abbreviation, ftm.abbreviation, td.abbreviation, pd.key, ct.cod) from ");
        query.append(' ').append(RequirementEntity.class.getName()).append(" pe ");
        query.append(" left join pe.flowDefinitionEntity pd  ");
        query.append(" left join pe.flowInstanceEntity pi  ");
        query.append(" left join pi.tasks ct  ");
        query.append(" left join ct.task t  ");
        query.append(" left join t.taskDefinition td  ");
        query.append(" left join pe.formRequirementEntities fpe ");
        query.append(" left join fpe.form for ");
        query.append(" left join for.formType ftm ");
        query.append(" left join fpe.currentDraftEntity cde  ");
        query.append(" left join cde.form  f ");
        query.append(" left join f.formType ft ");
        query.append(" where pe.cod = :requirementId and fpe.mainForm = :sim AND (ct.endDate is null or t.type = :fim )");
        query.append(" order by ct.cod DESC ");
        return Optional.ofNullable(this.getSession().createQuery(query.toString()).setParameter("sim", (Object)SimNao.SIM).setParameter("fim", (Object)TaskType.END).setParameter("requirementId", (Object)requirementId).setMaxResults(1).list()).filter(l -> !l.isEmpty()).map(l -> l.get(0)).orElse(null);
    }

    public List<RequirementEntity> findByRootRequirement(T rootRequirement) {
        String hql = "FROM " + RequirementEntity.class.getName() + " pe  WHERE pe.rootRequirement = :rootRequirement ";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("rootRequirement", rootRequirement);
        return query.list();
    }

    public List<FormAttachmentEntity> findFormAttachmentByCodRequirement(Long codRequirement) {
        QRequirementEntity requirement = new QRequirementEntity("requirementEntity");
        QFormRequirementEntity formRequirement = new QFormRequirementEntity("formRequirementEntity");
        QFormEntity form = new QFormEntity("formEntity");
        QDraftEntity currentDraft = new QDraftEntity("draftEntity");
        QFormEntity draftForm = new QFormEntity("draftFormEntity");
        QFormVersionEntity formVersion = new QFormVersionEntity("formVersionEntity");
        QFormAttachmentEntity formAttachment = new QFormAttachmentEntity("formAttachmentEntity");
        return ((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new HibernateQueryFactory(this.getSession()).selectDistinct((Expression)formAttachment).from((EntityPath)requirement)).innerJoin(requirement.formRequirementEntities, (Path)formRequirement)).leftJoin((EntityPath)formRequirement.form, (Path)form)).leftJoin((EntityPath)formRequirement.currentDraftEntity, (Path)currentDraft)).leftJoin((EntityPath)currentDraft.form, (Path)draftForm)).from((EntityPath)formVersion)).from((EntityPath)formAttachment)).where((Predicate)new BooleanBuilder().and((Predicate)formVersion.formEntity.cod.eq((Expression)form.cod).or((Predicate)formVersion.formEntity.cod.eq((Expression)draftForm.cod))).and((Predicate)formAttachment.formVersionEntity.cod.eq((Expression)formVersion.cod)).and((Predicate)requirement.cod.eq((Object)codRequirement)))).fetch();
    }

    public boolean containChildren(Long codRequirement) {
        QRequirementEntity requirementEntity = QRequirementEntity.requirementEntity;
        return ((HibernateQuery)new HibernateQueryFactory(this.getSession()).selectFrom((EntityPath)requirementEntity).where((Predicate)requirementEntity.parentRequirement.cod.eq((Object)codRequirement))).fetchCount() > 0L;
    }

    public T findRequirementByRootRequirementAndType(Long rootRequirement, String type) {
        QRequirementEntity requirement = new QRequirementEntity("requirement");
        QFormRequirementEntity formRequirement = new QFormRequirementEntity("formRequirement");
        QFormEntity form = new QFormEntity("form");
        QFormTypeEntity formTypeEntity = new QFormTypeEntity("formType");
        HibernateQuery hibernateQuery = (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new HibernateQueryFactory(this.getSession()).selectFrom((EntityPath)requirement).innerJoin(requirement.formRequirementEntities, (Path)formRequirement)).innerJoin((EntityPath)formRequirement.form, (Path)form)).innerJoin((EntityPath)form.formType, (Path)formTypeEntity)).where((Predicate)formRequirement.mainForm.eq((Object)SimNao.SIM).and((Predicate)requirement.rootRequirement.cod.eq((Object)rootRequirement)).and((Predicate)formTypeEntity.abbreviation.eq((Object)type)));
        hibernateQuery.getMetadata().setLimit(Long.valueOf(1L));
        return (T)((Object)((RequirementEntity)((Object)hibernateQuery.fetchOne())));
    }
}

