/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.entity.form;

import java.util.Collections;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.opensingular.flow.persistence.entity.FlowDefinitionEntity;
import org.opensingular.flow.persistence.entity.FlowInstanceEntity;
import org.opensingular.form.SType;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.lib.support.persistence.entity.BaseEntity;
import org.opensingular.lib.support.persistence.enums.SimNao;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.persistence.entity.form.ApplicantEntity;
import org.opensingular.server.commons.persistence.entity.form.DraftEntity;
import org.opensingular.server.commons.persistence.entity.form.FormRequirementEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementDefinitionEntity;
import org.opensingular.server.commons.service.RequirementUtil;

@Entity
@Table(schema="DBSINGULAR", name="TB_REQUISICAO")
@GenericGenerator(name="GENERATED_CO_REQUISICAO", strategy="org.opensingular.lib.support.persistence.util.HybridIdentityOrSequenceGenerator")
public class RequirementEntity
extends BaseEntity<Long> {
    public static final String PK_GENERATOR_NAME = "GENERATED_CO_REQUISICAO";
    @Id
    @Column(name="CO_REQUISICAO")
    @GeneratedValue(generator="GENERATED_CO_REQUISICAO")
    private Long cod;
    @ManyToOne
    @JoinColumn(name="CO_INSTANCIA_PROCESSO")
    private FlowInstanceEntity flowInstanceEntity;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CO_DEFINICAO_PROCESSO")
    private FlowDefinitionEntity flowDefinitionEntity;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CO_REQUISITANTE")
    private ApplicantEntity applicant;
    @Column(name="DS_REQUISICAO")
    private String description;
    @OneToMany(mappedBy="requirement", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @OrderBy(value=" CO_FORMULARIO_REQUISICAO ASC ")
    private SortedSet<FormRequirementEntity> formRequirementEntities;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="CO_REQUISICAO_RAIZ")
    private RequirementEntity rootRequirement;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="CO_REQUISICAO_PAI")
    private RequirementEntity parentRequirement;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="CO_DEFINICAO_REQUISICAO")
    private RequirementDefinitionEntity requirementDefinitionEntity;

    public Long getCod() {
        return this.cod;
    }

    public void setCod(Long cod) {
        this.cod = cod;
    }

    public FlowInstanceEntity getFlowInstanceEntity() {
        return this.flowInstanceEntity;
    }

    public void setFlowInstanceEntity(FlowInstanceEntity flowInstanceEntity) {
        this.flowInstanceEntity = flowInstanceEntity;
    }

    public FlowDefinitionEntity getFlowDefinitionEntity() {
        return this.flowDefinitionEntity;
    }

    public void setFlowDefinitionEntity(FlowDefinitionEntity flowDefinitionEntity) {
        this.flowDefinitionEntity = flowDefinitionEntity;
    }

    public ApplicantEntity getApplicant() {
        return this.applicant;
    }

    public void setApplicant(ApplicantEntity applicant) {
        this.applicant = applicant;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RequirementEntity getRootRequirement() {
        return this.rootRequirement;
    }

    public void setRootRequirement(RequirementEntity rootRequirement) {
        this.rootRequirement = rootRequirement;
    }

    public RequirementEntity getParentRequirement() {
        return this.parentRequirement;
    }

    public void setParentRequirement(RequirementEntity parentRequirement) {
        this.parentRequirement = parentRequirement;
    }

    public RequirementDefinitionEntity getRequirementDefinitionEntity() {
        return this.requirementDefinitionEntity;
    }

    public void setRequirementDefinitionEntity(RequirementDefinitionEntity requirementDefinitionEntity) {
        this.requirementDefinitionEntity = requirementDefinitionEntity;
    }

    public SortedSet<FormRequirementEntity> getFormRequirementEntities() {
        if (this.formRequirementEntities == null) {
            this.formRequirementEntities = new TreeSet<FormRequirementEntity>();
        }
        return this.formRequirementEntities;
    }

    public void setFormRequirementEntities(SortedSet<FormRequirementEntity> formRequirementEntities) {
        this.formRequirementEntities = formRequirementEntities;
    }

    @Nonnull
    public FormEntity getMainForm() {
        FormEntity form = null;
        if (this.formRequirementEntities != null) {
            form = this.formRequirementEntities.stream().filter(f -> SimNao.SIM == f.getMainForm()).map(f -> {
                if (f.getForm() != null) {
                    return f.getForm();
                }
                if (f.getCurrentDraftEntity() != null) {
                    return f.getCurrentDraftEntity().getForm();
                }
                return null;
            }).findFirst().orElse(null);
        }
        if (form == null) {
            throw SingularServerException.rethrow("Base incossistente. N\u00e3o foi encontrado o main form da peti\u00e7\u00e3o.");
        }
        return form;
    }

    @Nonnull
    public Optional<DraftEntity> currentEntityDraftByType(@Nonnull Class<? extends SType<?>> typeClass) {
        return this.currentEntityDraftByType(RequirementUtil.getTypeName(typeClass));
    }

    @Nonnull
    public Optional<DraftEntity> currentEntityDraftByType(@Nonnull String typeName) {
        return Optional.ofNullable(this.formRequirementEntities).orElse((SortedSet<FormRequirementEntity>)Collections.emptySet()).stream().filter(f -> f.getCurrentDraftEntity() != null && RequirementUtil.getTypeName(f.getCurrentDraftEntity()).equals(typeName)).findFirst().map(FormRequirementEntity::getCurrentDraftEntity);
    }
}

