/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class FilterToken {
    private String token;
    private boolean exact;

    public FilterToken(@Nonnull String token) {
        this(token, false);
    }

    public FilterToken(@Nonnull String token, boolean exact) {
        this.token = token;
        this.exact = exact;
    }

    public List<String> getAllPossibleMatches() {
        if (this.exact) {
            return Collections.singletonList(this.token);
        }
        ArrayList<String> matches = new ArrayList<String>();
        matches.add(this.get());
        matches.add(this.getOnlyNumbersAndLetters());
        return matches;
    }

    public String getRaw() {
        return this.token;
    }

    private String anywhereOrExact(String str) {
        return this.exact ? str : "%" + str + "%";
    }

    public String get() {
        return this.anywhereOrExact(this.token);
    }

    public String getOnlyNumbersAndLetters() {
        return this.anywhereOrExact(this.token.replaceAll("[^\\da-zA-Z]", ""));
    }

    public boolean isExact() {
        return this.exact;
    }

    public String toString() {
        return "FilterToken{token='" + this.token + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterToken that = (FilterToken)o;
        return Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }
}

