/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.server.commons.persistence.filter.FilterToken;

public class FilterTokenFactory {
    public static final String QUOTATION_MARK_FIND_REGEX = "\"[^\"].*?\"";
    private final String rawFilter;
    private String dynamicFilter;
    private List<FilterToken> tokens;

    public FilterTokenFactory(@Nonnull String rawFilter) {
        this.rawFilter = rawFilter;
    }

    public List<FilterToken> make() {
        this.dynamicFilter = this.rawFilter;
        this.tokens = new ArrayList<FilterToken>();
        this.addExactTokens();
        this.addAnywhereTokens();
        return this.tokens;
    }

    private void addAnywhereTokens() {
        Arrays.stream(this.dynamicFilter.split(" ")).filter(StringUtils::isNotBlank).map(FilterToken::new).forEach(this.tokens::add);
    }

    private void addExactTokens() {
        Matcher matcher = Pattern.compile(QUOTATION_MARK_FIND_REGEX).matcher(this.rawFilter);
        while (matcher.find()) {
            String matched = this.rawFilter.substring(matcher.start(), matcher.end());
            this.tokens.add(new FilterToken(matched.replace("\"", ""), true));
            this.dynamicFilter = this.dynamicFilter.replaceFirst(matched, "");
        }
    }
}

