/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.filter;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensingular.server.commons.persistence.filter.FilterToken;
import org.opensingular.server.commons.persistence.filter.FilterTokenFactory;

public class QuickFilter
implements Serializable {
    private String filter;
    private boolean rascunho;
    private String idPessoa;
    private String idUsuarioLogado;
    private int first;
    private int count;
    private String sortProperty;
    private boolean ascending;
    private Boolean endedTasks;
    private List<String> tasks;
    private List<String> processesAbbreviation;
    private List<String> typesNames;

    public QuickFilter withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getIdUsuarioLogado() {
        return this.idUsuarioLogado;
    }

    public QuickFilter withIdUsuarioLogado(String idUsuarioLogado) {
        this.idUsuarioLogado = idUsuarioLogado;
        return this;
    }

    public String getIdPessoa() {
        return this.idPessoa;
    }

    public QuickFilter withIdPessoa(String idPessoa) {
        this.idPessoa = idPessoa;
        return this;
    }

    public boolean isRascunho() {
        return this.rascunho;
    }

    public QuickFilter withRascunho(boolean rascunho) {
        this.rascunho = rascunho;
        return this;
    }

    public int getFirst() {
        return this.first;
    }

    public QuickFilter withFirst(int first) {
        this.first = first;
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public QuickFilter withCount(int count) {
        this.count = count;
        return this;
    }

    public String getSortProperty() {
        return this.sortProperty;
    }

    public QuickFilter withSortProperty(String sortProperty) {
        this.sortProperty = sortProperty;
        return this;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public QuickFilter withAscending(boolean ascending) {
        this.ascending = ascending;
        return this;
    }

    public QuickFilter sortAscending() {
        this.ascending = true;
        return this;
    }

    public QuickFilter sortDescending() {
        this.ascending = false;
        return this;
    }

    public boolean hasFilter() {
        return this.filter != null && !this.filter.isEmpty();
    }

    public QuickFilter forTasks(String ... tasks) {
        this.tasks = Arrays.asList(tasks);
        return this;
    }

    public List<String> getTasks() {
        return this.tasks;
    }

    public List<String> getProcessesAbbreviation() {
        return this.processesAbbreviation;
    }

    public QuickFilter withProcessesAbbreviation(List<String> processesAbbreviation) {
        this.processesAbbreviation = processesAbbreviation;
        return this;
    }

    public List<String> getTypesNames() {
        return this.typesNames;
    }

    public QuickFilter withTypesNames(List<String> typesNames) {
        this.typesNames = typesNames;
        return this;
    }

    public Boolean getEndedTasks() {
        return this.endedTasks;
    }

    public QuickFilter withEndedTasks(Boolean endedTasks) {
        this.endedTasks = endedTasks;
        return this;
    }

    public List<FilterToken> listFilterTokens() {
        if (this.filter != null) {
            return new FilterTokenFactory(this.filter).make();
        }
        return Collections.emptyList();
    }

    public String getFilter() {
        return this.filter;
    }
}

