/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.query;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.hibernate.HibernateQuery;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Session;
import org.opensingular.flow.core.TaskType;
import org.opensingular.lib.support.persistence.enums.SimNao;
import org.opensingular.server.commons.persistence.context.RequirementSearchAliases;
import org.opensingular.server.commons.persistence.context.RequirementSearchContext;
import org.opensingular.server.commons.persistence.filter.FilterToken;
import org.opensingular.server.commons.persistence.filter.QuickFilter;
import org.opensingular.server.commons.persistence.query.RequirementSearchQuery;

public class RequirementSearchQueryFactory {
    private static final String TO_CHAR_DATE = "TO_CHAR({0}, 'DD/MM/YYYY HH24:MI')";
    private final RequirementSearchContext ctx;
    private RequirementSearchAliases $;
    private RequirementSearchQuery query;
    private QuickFilter quickFilter;
    private BooleanBuilder whereClause;

    public RequirementSearchQueryFactory(RequirementSearchContext ctx) {
        this.ctx = ctx;
    }

    public RequirementSearchQuery make(Session session) {
        this.configure(session);
        this.appendSelect();
        this.appendWhere();
        this.applyExtenders();
        this.appendOrder();
        return this.query;
    }

    private void configure(Session session) {
        this.query = new RequirementSearchQuery(session);
        this.$ = this.ctx.getAliases();
        this.quickFilter = this.ctx.getQuickFilter();
        this.whereClause = this.query.getWhereClause();
        this.ctx.setQuery(this.query);
        if (this.quickFilter.isRascunho()) {
            this.query.setDefaultOrder(new OrderSpecifier(Order.ASC, (Expression)Expressions.stringPath((String)"creationDate")));
        } else {
            this.query.setDefaultOrder(new OrderSpecifier(Order.ASC, (Expression)Expressions.stringPath((String)"processBeginDate")));
        }
    }

    private void appendSelect() {
        if (Boolean.TRUE.equals(this.ctx.getCount())) {
            this.query.countBy((BeanPath<?>)this.$.requirement);
        } else {
            this.query.getSelect().add((Expression<?>)this.$.requirement.cod.as("codRequirement")).add((Expression<?>)this.$.requirement.description.as("description")).add((Expression<?>)this.$.taskVersion.name.as("situation")).add((Expression<?>)this.$.taskVersion.name.as("taskName")).add((Expression<?>)this.$.taskVersion.type.as("taskType")).add((Expression<?>)this.$.flowDefinitionEntity.name.as("processName")).addCase($case -> ((DateTimeExpression)$case.when((Predicate)this.$.currentFormDraftVersionEntity.isNull()).then((DateTimeExpression)this.$.currentFormVersion.inclusionDate).otherwise((Expression)this.$.currentFormDraftVersionEntity.inclusionDate)).as("creationDate")).addCase($case -> ((StringExpression)$case.when((Predicate)this.$.formType.abbreviation.isNull()).then((StringExpression)this.$.formDraftType.abbreviation).otherwise((Expression)this.$.formType.abbreviation)).as("type")).add((Expression<?>)this.$.flowDefinitionEntity.key.as("processType")).add((Expression<?>)this.$.task.beginDate.as("situationBeginDate")).add((Expression<?>)this.$.task.cod.as("taskInstanceId")).add((Expression<?>)this.$.flowInstance.beginDate.as("processBeginDate")).add((Expression<?>)this.$.currentDraftEntity.editionDate.as("editionDate")).add((Expression<?>)this.$.flowInstance.cod.as("flowInstanceId")).add((Expression<?>)this.$.requirement.rootRequirement.cod.as("rootRequirement")).add((Expression<?>)this.$.requirement.parentRequirement.cod.as("parentRequirement")).add((Expression<?>)this.$.taskDefinition.cod.as("taskId")).add((Expression<?>)this.$.task.versionStamp.as("versionStamp")).add((Expression<?>)this.$.allocatedUser.codUsuario.as("codUsuarioAlocado")).add((Expression<?>)this.$.allocatedUser.nome.as("nomeUsuarioAlocado")).add((Expression<?>)this.$.module.cod.as("moduleCod")).add((Expression<?>)this.$.module.connectionURL.as("moduleContext")).add((Expression<?>)this.$.requirementDefinition.cod.as("requirementDefinitionId"));
        }
        ((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)this.query.from((EntityPath)this.$.requirement)).leftJoin((EntityPath)this.$.requirement.applicant, (Path)this.$.applicantEntity)).leftJoin((EntityPath)this.$.requirement.flowInstanceEntity, (Path)this.$.flowInstance)).leftJoin(this.$.requirement.formRequirementEntities, (Path)this.$.formRequirementEntity)).on((Predicate)this.$.formRequirementEntity.mainForm.eq((Object)SimNao.SIM))).leftJoin((EntityPath)this.$.formRequirementEntity.form, (Path)this.$.formEntity)).leftJoin((EntityPath)this.$.formRequirementEntity.currentDraftEntity, (Path)this.$.currentDraftEntity)).leftJoin((EntityPath)this.$.currentDraftEntity.form, (Path)this.$.formDraftEntity)).leftJoin((EntityPath)this.$.formDraftEntity.currentFormVersionEntity, (Path)this.$.currentFormDraftVersionEntity)).leftJoin((EntityPath)this.$.formEntity.currentFormVersionEntity, (Path)this.$.currentFormVersion)).leftJoin((EntityPath)this.$.requirement.flowDefinitionEntity, (Path)this.$.flowDefinitionEntity)).leftJoin((EntityPath)this.$.formEntity.formType, (Path)this.$.formType)).leftJoin((EntityPath)this.$.formDraftEntity.formType, (Path)this.$.formDraftType)).leftJoin((CollectionExpression)this.$.flowInstance.tasks, (Path)this.$.task)).leftJoin((EntityPath)this.$.task.task, (Path)this.$.taskVersion)).leftJoin((EntityPath)this.$.taskVersion.taskDefinition, (Path)this.$.taskDefinition)).leftJoin((EntityPath)this.$.task.allocatedUser, (Path)this.$.allocatedUser)).leftJoin((EntityPath)this.$.requirement.requirementDefinitionEntity, (Path)this.$.requirementDefinition)).leftJoin((EntityPath)this.$.requirementDefinition.module, (Path)this.$.module);
    }

    @Nonnull
    private void appendWhere() {
        this.appendFilterByApplicant();
        this.appendFilterByFlowDefinitionAbbreviation();
        this.appendFilterByQuickFilter();
        this.appendFilterByTasks();
        if (this.quickFilter.isRascunho()) {
            this.appendFilterByRequirementsWithoutFlowInstance();
        } else {
            this.appendFilterByRequirementsWithFlowInstance();
            this.appendFilterByCurrentTask();
        }
    }

    private void appendFilterByCurrentTask() {
        if (this.quickFilter.getEndedTasks() == null) {
            this.whereClause.and((Predicate)this.$.taskVersion.type.eq((Object)TaskType.END).or((Predicate)this.$.taskVersion.type.ne((Object)TaskType.END).and((Predicate)this.$.task.endDate.isNull())));
        } else if (Boolean.TRUE.equals(this.quickFilter.getEndedTasks())) {
            this.whereClause.and((Predicate)this.$.taskVersion.type.eq((Object)TaskType.END));
        } else {
            this.whereClause.and((Predicate)this.$.task.endDate.isNull());
        }
    }

    private void appendFilterByRequirementsWithFlowInstance() {
        this.whereClause.and((Predicate)this.$.requirement.flowInstanceEntity.isNotNull());
    }

    private void appendFilterByRequirementsWithoutFlowInstance() {
        this.whereClause.and((Predicate)this.$.requirement.flowInstanceEntity.isNull());
    }

    private void appendFilterByTasks() {
        if (!CollectionUtils.isEmpty(this.quickFilter.getTasks())) {
            this.whereClause.and((Predicate)this.$.taskVersion.name.in(this.quickFilter.getTasks()));
        }
    }

    private void appendFilterByQuickFilter() {
        if (this.ctx.getQuickFilter().hasFilter()) {
            BooleanBuilder filterBooleanBuilder = new BooleanBuilder();
            for (FilterToken token : this.quickFilter.listFilterTokens()) {
                BooleanBuilder tokenBooleanBuilder = new BooleanBuilder();
                for (String filter : token.getAllPossibleMatches()) {
                    tokenBooleanBuilder.or((Predicate)this.buildQuickFilterBooleanExpression(this.$, filter));
                }
                filterBooleanBuilder.and((Predicate)tokenBooleanBuilder);
            }
            this.query.getQuickFilterWhereClause().or((Predicate)filterBooleanBuilder);
        }
    }

    private void appendFilterByApplicant() {
        if (this.quickFilter.getIdPessoa() != null) {
            this.whereClause.and((Predicate)this.$.applicantEntity.idPessoa.eq((Object)this.quickFilter.getIdPessoa()));
        }
    }

    private void appendFilterByFlowDefinitionAbbreviation() {
        if (!this.quickFilter.isRascunho() && this.quickFilter.getProcessesAbbreviation() != null && !this.quickFilter.getProcessesAbbreviation().isEmpty()) {
            BooleanExpression expr = this.$.flowDefinitionEntity.key.in(this.quickFilter.getProcessesAbbreviation());
            if (this.quickFilter.getTypesNames() != null && !this.quickFilter.getTypesNames().isEmpty()) {
                expr = expr.or((Predicate)this.$.formType.abbreviation.in(this.quickFilter.getTypesNames()));
            }
            this.whereClause.and((Predicate)expr);
        }
    }

    private void applyExtenders() {
        if (this.ctx.getExtenders() != null) {
            this.ctx.getExtenders().forEach(extender -> extender.extend(this.ctx));
        }
    }

    private void appendOrder() {
        if (this.quickFilter.getSortProperty() != null) {
            Order order = this.quickFilter.isAscending() ? Order.ASC : Order.DESC;
            this.query.orderBy(new OrderSpecifier(order, (Expression)Expressions.stringPath((String)this.quickFilter.getSortProperty())));
        } else if (!Boolean.TRUE.equals(this.ctx.getCount()) && this.query.getMetadata().getOrderBy().isEmpty() && this.query.getDefaultOrder() != null) {
            this.query.orderBy(this.query.getDefaultOrder());
        }
    }

    private BooleanBuilder buildQuickFilterBooleanExpression(RequirementSearchAliases $, String filter) {
        return new BooleanBuilder().or((Predicate)$.allocatedUser.nome.likeIgnoreCase(filter)).or((Predicate)$.requirement.description.likeIgnoreCase(filter)).or((Predicate)$.flowDefinitionEntity.name.likeIgnoreCase(filter)).or((Predicate)$.taskVersion.name.likeIgnoreCase(filter)).or((Predicate)$.requirement.cod.like(filter)).or((Predicate)this.toCharDate((Path<?>)$.currentFormVersion.inclusionDate).like(filter)).or((Predicate)this.toCharDate((Path<?>)$.currentFormDraftVersionEntity.inclusionDate).like(filter)).or((Predicate)this.toCharDate((Path<?>)$.currentDraftEntity.editionDate).like(filter)).or((Predicate)this.toCharDate((Path<?>)$.task.beginDate).like(filter)).or((Predicate)this.toCharDate((Path<?>)$.flowInstance.beginDate).like(filter));
    }

    @Nonnull
    private StringTemplate toCharDate(Path<?> path) {
        return Expressions.stringTemplate((String)TO_CHAR_DATE, (Object[])new Object[]{path});
    }
}

