/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.persistence.requirement;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.hibernate.HibernateQuery;
import javax.annotation.Nonnull;
import org.opensingular.flow.persistence.entity.QVariableInstanceEntity;
import org.opensingular.server.commons.persistence.context.RequirementSearchAliases;
import org.opensingular.server.commons.persistence.context.RequirementSearchContext;
import org.opensingular.server.commons.persistence.filter.FilterToken;
import org.opensingular.server.commons.persistence.filter.QuickFilter;
import org.opensingular.server.commons.persistence.query.RequirementSearchQuery;
import org.opensingular.server.commons.persistence.requirement.RequirementSearchExtender;

public class FlowVariableRequirementSearchExtender
implements RequirementSearchExtender {
    public static final String TO_CHAR_TEMPLATE = "to_char({0})";
    public static final String TO_CHAR_DATE_TEMPLATE = "to_date(to_char({0}), 'dd/MM/yyyy')";
    private final String variableName;
    private final String queryAlias;
    private final String toCharTemplate;

    public FlowVariableRequirementSearchExtender(@Nonnull String variableName, @Nonnull String queryAlias) {
        this(variableName, queryAlias, TO_CHAR_TEMPLATE);
    }

    public FlowVariableRequirementSearchExtender(@Nonnull String variableName, @Nonnull String queryAlias, @Nonnull String toCharTemplate) {
        this.variableName = variableName;
        this.queryAlias = queryAlias;
        this.toCharTemplate = toCharTemplate;
    }

    @Override
    public void extend(@Nonnull RequirementSearchContext context) {
        QVariableInstanceEntity variableEntity = new QVariableInstanceEntity(this.variableName);
        RequirementSearchQuery query = context.getQuery();
        RequirementSearchAliases $ = context.getAliases();
        this.createSelect(variableEntity, context);
        ((HibernateQuery)query.leftJoin((CollectionExpression)$.flowInstance.variables, (Path)variableEntity)).on((Predicate)variableEntity.name.eq((Object)this.variableName));
        QuickFilter quickFilter = context.getQuickFilter();
        if (context.getQuickFilter().hasFilter()) {
            BooleanBuilder filterBooleanBuilder = new BooleanBuilder();
            for (FilterToken token : quickFilter.listFilterTokens()) {
                BooleanBuilder tokenBooleanBuilder = new BooleanBuilder();
                for (String filter : token.getAllPossibleMatches()) {
                    tokenBooleanBuilder.or((Predicate)this.toChar(variableEntity).likeIgnoreCase(filter));
                }
                filterBooleanBuilder.and((Predicate)tokenBooleanBuilder);
            }
            query.getQuickFilterWhereClause().or((Predicate)filterBooleanBuilder);
        }
    }

    protected void createSelect(QVariableInstanceEntity variableEntity, RequirementSearchContext context) {
        context.getQuery().getSelect().add((Expression<?>)this.toChar(variableEntity).as(this.queryAlias));
    }

    @Nonnull
    protected StringTemplate toChar(QVariableInstanceEntity var) {
        return Expressions.stringTemplate((String)this.toCharTemplate, (Object[])new Object[]{var.value});
    }
}

