/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.opensingular.flow.core.FlowDefinition;
import org.opensingular.flow.core.FlowInstance;
import org.opensingular.form.SInstance;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.service.FormRequirementService;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.service.RequirementSender;
import org.opensingular.server.commons.service.RequirementService;
import org.opensingular.server.commons.service.RequirementUtil;
import org.opensingular.server.commons.service.dto.RequirementSenderFeedback;

@Transactional
public class DefaultRequirementSender
implements RequirementSender {
    @Inject
    private RequirementService<RequirementEntity, RequirementInstance> requirementService;
    @Inject
    private FormRequirementService<RequirementEntity> formRequirementService;

    @Override
    public RequirementSenderFeedback send(@Nonnull RequirementInstance requirement, SInstance instance, @Nullable String codSubmitterActor) {
        List<FormEntity> consolidatedDrafts = this.formRequirementService.consolidateDrafts(requirement);
        FlowDefinition<?> flowDefinition = RequirementUtil.getFlowDefinition(requirement.getEntity());
        this.requirementService.onBeforeStartFlow(requirement, instance, codSubmitterActor);
        FlowInstance flowInstance = this.requirementService.startNewFlow(requirement, flowDefinition, codSubmitterActor);
        this.requirementService.onAfterStartFlow(requirement, instance, codSubmitterActor, flowInstance);
        this.requirementService.saveRequirementHistory(requirement, consolidatedDrafts);
        return new RequirementSenderFeedback(requirement);
    }
}

