/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.opensingular.flow.core.TaskInstance;
import org.opensingular.flow.core.entity.IEntityTaskDefinition;
import org.opensingular.flow.core.service.IUserService;
import org.opensingular.flow.persistence.entity.TaskDefinitionEntity;
import org.opensingular.flow.persistence.entity.TaskInstanceEntity;
import org.opensingular.flow.persistence.entity.TaskVersionEntity;
import org.opensingular.form.SIComposite;
import org.opensingular.form.SIList;
import org.opensingular.form.SInstance;
import org.opensingular.form.SType;
import org.opensingular.form.SingularFormException;
import org.opensingular.form.context.SFormConfig;
import org.opensingular.form.document.RefType;
import org.opensingular.form.document.SDocument;
import org.opensingular.form.document.SDocumentConsumer;
import org.opensingular.form.document.SDocumentFactory;
import org.opensingular.form.io.SFormXMLUtil;
import org.opensingular.form.persistence.FormKey;
import org.opensingular.form.persistence.dao.FormAnnotationDAO;
import org.opensingular.form.persistence.dao.FormAnnotationVersionDAO;
import org.opensingular.form.persistence.dao.FormAttachmentDAO;
import org.opensingular.form.persistence.dao.FormDAO;
import org.opensingular.form.persistence.dao.FormVersionDAO;
import org.opensingular.form.persistence.entity.FormAnnotationEntity;
import org.opensingular.form.persistence.entity.FormAnnotationVersionEntity;
import org.opensingular.form.persistence.entity.FormAttachmentEntity;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.form.service.FormFieldService;
import org.opensingular.form.service.IFormService;
import org.opensingular.form.util.transformer.Value;
import org.opensingular.lib.commons.lambda.IConsumer;
import org.opensingular.lib.support.persistence.entity.BaseEntity;
import org.opensingular.lib.support.persistence.enums.SimNao;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.persistence.dao.form.DraftDAO;
import org.opensingular.server.commons.persistence.dao.form.FormRequirementDAO;
import org.opensingular.server.commons.persistence.entity.form.DraftEntity;
import org.opensingular.server.commons.persistence.entity.form.FormRequirementEntity;
import org.opensingular.server.commons.persistence.entity.form.FormVersionHistoryEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementContentHistoryEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.service.RequirementUtil;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FormRequirementService<P extends RequirementEntity> {
    @Inject
    protected IFormService formPersistenceService;
    @Inject
    private FormFieldService formFieldService;
    @Inject
    private IUserService userService;
    @Inject
    protected FormRequirementDAO formRequirementDAO;
    @Inject
    protected DraftDAO draftDAO;
    @Inject
    protected FormDAO formDAO;
    @Inject
    protected FormVersionDAO formVersionDAO;
    @Inject
    protected FormAnnotationDAO formAnnotationDAO;
    @Inject
    protected FormAnnotationVersionDAO formAnnotationVersionDAO;
    @Inject
    private FormAttachmentDAO formAttachmentDAO;
    @Inject
    @Named(value="formConfigWithDatabase")
    private Optional<SFormConfig<String>> singularFormConfig;

    @Nonnull
    public FormRequirementEntity findFormRequirementEntityByCod(@Nonnull Long cod) {
        return (FormRequirementEntity)this.formRequirementDAO.findOrException(cod);
    }

    @Nonnull
    public Optional<FormRequirementEntity> findFormRequirementEntityByType(@Nonnull RequirementInstance requirement, @Nonnull String typeName) {
        Objects.requireNonNull(requirement);
        return this.formRequirementDAO.findFormRequirementEntityByTypeName(requirement.getCod(), typeName);
    }

    @Nonnull
    public Optional<FormRequirementEntity> findFormRequirementEntityByTypeAndTask(@Nonnull RequirementInstance requirement, @Nonnull Class<? extends SType<?>> typeClass, @Nonnull TaskInstance task) {
        return this.findFormRequirementEntityByTypeAndTask(requirement, RequirementUtil.getTypeName(typeClass), task);
    }

    @Nonnull
    public Optional<FormRequirementEntity> findFormRequirementEntityByTypeAndTask(@Nonnull RequirementInstance requirement, @Nonnull String typeName, @Nonnull TaskInstance task) {
        Objects.requireNonNull(requirement);
        Objects.requireNonNull(task);
        Integer taskDefinitionEntityPK = ((TaskDefinitionEntity)((TaskVersionEntity)((TaskInstanceEntity)task.getEntityTaskInstance()).getTaskVersion()).getTaskDefinition()).getCod();
        return this.formRequirementDAO.findFormRequirementEntityByTypeNameAndTask(requirement.getCod(), typeName, taskDefinitionEntityPK);
    }

    @Nonnull
    public Optional<FormRequirementEntity> findLastFormRequirementEntityByType(@Nonnull RequirementInstance requirement, @Nonnull Class<? extends SType<?>> typeClass) {
        return this.findLastFormRequirementEntityByType(requirement, RequirementUtil.getTypeName(typeClass));
    }

    public Optional<FormRequirementEntity> findLastFormRequirementEntityByType(@Nonnull RequirementInstance requirement, @Nonnull String typeName) {
        return this.formRequirementDAO.findLastFormRequirementEntityByTypeName(requirement.getCod(), typeName);
    }

    @Nonnull
    public Optional<FormRequirementEntity> findFormRequirementEntity(@Nonnull RequirementInstance requirement, @Nonnull Class<? extends SType<?>> typeClass, boolean mainForm) {
        return FormRequirementService.findFormRequirementEntity(requirement, RequirementUtil.getTypeName(typeClass), mainForm);
    }

    @Nonnull
    private static Optional<FormRequirementEntity> findFormRequirementEntity(@Nonnull RequirementInstance requirement, @Nonnull String typeName, boolean mainForm) {
        Optional<IEntityTaskDefinition> currentTask;
        Stream<Object> entities = requirement.getEntity().getFormRequirementEntities().stream();
        entities = entities.filter(x -> {
            if (x.getForm() != null) {
                return typeName.equals(RequirementUtil.getTypeName(x));
            }
            if (x.getCurrentDraftEntity() != null) {
                return typeName.equals(RequirementUtil.getTypeName(x.getCurrentDraftEntity()));
            }
            return false;
        });
        if (!mainForm && (currentTask = RequirementUtil.getCurrentTaskDefinitionOpt(requirement.getEntity())).isPresent()) {
            entities = entities.filter(x -> x.getTaskDefinitionEntity().equals(currentTask.get()));
        }
        return entities.findFirst();
    }

    @Nonnull
    public Optional<SInstance> findFormRequirementInstanceByTypeAndTask(@Nonnull RequirementInstance requirement, @Nonnull Class<? extends SType<?>> typeClass, @Nonnull TaskInstance task) {
        return this.findFormRequirementEntityByTypeAndTask(requirement, RequirementUtil.getTypeName(typeClass), task).map(e -> this.getSInstance((FormRequirementEntity)e, (Class)typeClass));
    }

    @Nonnull
    public <I extends SInstance, K extends SType<? extends I>> Optional<I> findLastFormRequirementInstanceByType(@Nonnull RequirementInstance requirement, @Nonnull Class<K> typeClass) {
        return this.findLastFormRequirementEntityByType(requirement, RequirementUtil.getTypeName(typeClass)).map(e -> this.getSInstance((FormRequirementEntity)e, typeClass));
    }

    @Nonnull
    static <I extends SInstance, K extends SType<? extends I>> I checkIfExpectedType(@Nonnull SInstance instance, @Nonnull Class<K> expectedTypeClass) {
        if (instance == null) {
            throw SingularServerException.rethrow("O resultado da recupera\u00e7\u00e3o da SInstance retornou null");
        }
        if (!expectedTypeClass.isAssignableFrom(instance.getType().getClass())) {
            throw new SingularFormException("Era esperado a inst\u00e2ncia recuperada fosse do tipo " + expectedTypeClass.getName() + " mas ela \u00e9 do tipo " + instance.getType().getClass(), instance);
        }
        return (I)instance;
    }

    @Nonnull
    public <I extends SInstance, K extends SType<? extends I>> I getSInstance(@Nonnull FormRequirementEntity f, @Nonnull Class<K> expectedTypeClass) {
        return FormRequirementService.checkIfExpectedType(this.getSInstance(f), expectedTypeClass);
    }

    @Nonnull
    public SInstance getSInstance(@Nonnull FormRequirementEntity f) {
        return this.getSInstance(f.getForm());
    }

    @Nonnull
    public <I extends SInstance, K extends SType<? extends I>> I getSInstance(@Nonnull FormVersionEntity version, Class<K> expectedTypeClass) {
        return FormRequirementService.checkIfExpectedType(this.getSInstance(version), expectedTypeClass);
    }

    @Nonnull
    public SInstance getSInstance(@Nonnull FormVersionEntity version) {
        FormEntity formEntity = version.getFormEntity();
        FormKey formKey = this.formKeyFromFormEntity(formEntity);
        RefType refType = this.loadRefType(RequirementUtil.getTypeName(formEntity));
        return this.formPersistenceService.loadSInstance(formKey, refType, this.getFactory(null), version.getCod());
    }

    @Nonnull
    public <I extends SInstance, K extends SType<? extends I>> I getSInstance(@Nonnull FormEntity f, @Nonnull Class<K> expectedTypeClass) {
        return FormRequirementService.checkIfExpectedType(this.getSInstance(f), expectedTypeClass);
    }

    @Nonnull
    public SInstance getSInstance(@Nonnull FormEntity f) {
        FormKey formKey = this.formKeyFromFormEntity(f);
        RefType refType = this.loadRefType(RequirementUtil.getTypeName(f));
        return this.getSInstance(formKey, refType, null);
    }

    @Nonnull
    public SInstance getSInstance(@Nonnull FormKey formKey, @Nonnull RefType refType) {
        return this.getSInstance(formKey, refType, null);
    }

    @Nonnull
    public SInstance getSInstance(@Nonnull FormKey formKey, @Nonnull RefType refType, @Nullable SDocumentConsumer extraFactorySetupSteps) {
        return this.formPersistenceService.loadSInstance(formKey, refType, this.getFactory(extraFactorySetupSteps));
    }

    @Nonnull
    public List<FormVersionEntity> findTwoLastFormVersions(@Nonnull Long codForm) {
        return this.formRequirementDAO.findTwoLastFormVersions(Objects.requireNonNull(codForm));
    }

    @Nonnull
    public Long countVersions(@Nonnull Long codForm) {
        return this.formRequirementDAO.countVersions(Objects.requireNonNull(codForm));
    }

    @Nonnull
    public FormKey saveFormRequirement(@Nonnull RequirementInstance requirement, @Nonnull SInstance instance, boolean mainForm) {
        FormRequirementEntity fpe;
        Integer codActor = this.userService.getUserCodIfAvailable();
        Optional<FormRequirementEntity> formRequirementEntity = FormRequirementService.findFormRequirementEntity(requirement, instance.getType().getName(), mainForm);
        if (!formRequirementEntity.isPresent()) {
            fpe = this.newFormRequirementEntity(requirement.getEntity(), mainForm);
            requirement.getEntity().getFormRequirementEntities().add(fpe);
        } else {
            fpe = formRequirementEntity.get();
        }
        DraftEntity currentDraftEntity = fpe.getCurrentDraftEntity();
        if (currentDraftEntity == null) {
            currentDraftEntity = this.createNewDraftWithoutSave();
        }
        this.saveOrUpdateDraft(instance, currentDraftEntity, codActor);
        fpe.setCurrentDraftEntity(currentDraftEntity);
        this.formRequirementDAO.saveOrUpdate(fpe);
        return this.formKeyFromFormEntity(currentDraftEntity.getForm());
    }

    @Nonnull
    private FormRequirementEntity newFormRequirementEntity(RequirementEntity requirement, boolean mainForm) {
        FormRequirementEntity formRequirementEntity = new FormRequirementEntity();
        formRequirementEntity.setRequirement(requirement);
        if (mainForm) {
            formRequirementEntity.setMainForm(SimNao.SIM);
        } else {
            formRequirementEntity.setMainForm(SimNao.NAO);
            formRequirementEntity.setTaskDefinitionEntity(RequirementUtil.getCurrentTaskDefinitionOpt(requirement).orElse(null));
        }
        this.formRequirementDAO.saveOrUpdate(formRequirementEntity);
        return formRequirementEntity;
    }

    private DraftEntity saveOrUpdateDraft(SInstance instance, DraftEntity draftEntity, Integer actor) {
        SInstance draft = draftEntity.getForm() != null ? this.getSInstance(draftEntity.getForm()) : this.createInstance(this.loadRefType(instance.getType().getName()), null, false);
        FormRequirementService.copyValuesAndAnnotations(instance.getDocument(), draft.getDocument());
        draftEntity.setForm(this.formPersistenceService.loadFormEntity(this.formPersistenceService.insertOrUpdate(draft, actor)));
        draftEntity.setEditionDate(new Date());
        FormRequirementService.copyFormKey(draft, instance);
        this.draftDAO.saveOrUpdate(draftEntity);
        draft.getDocument().persistFiles();
        return draftEntity;
    }

    private static void copyFormKey(@Nonnull SInstance origen, @Nonnull SInstance destiny) {
        FormKey.fromOpt((SInstance)origen).ifPresent(key -> FormKey.set((SInstance)destiny, (FormKey)key));
    }

    private DraftEntity createNewDraftWithoutSave() {
        DraftEntity draftEntity = new DraftEntity();
        draftEntity.setStartDate(new Date());
        draftEntity.setEditionDate(new Date());
        return draftEntity;
    }

    @Nonnull
    public List<FormEntity> consolidateDrafts(@Nonnull RequirementInstance requirement) {
        return requirement.getEntity().getFormRequirementEntities().stream().filter(formRequirementEntity -> formRequirementEntity.getCurrentDraftEntity() != null).map(this::consolidadeDraft).collect(Collectors.toList());
    }

    private FormEntity consolidadeDraft(FormRequirementEntity formRequirementEntity) {
        DraftEntity draft = (DraftEntity)this.draftDAO.getOrException(formRequirementEntity.getCurrentDraftEntity().getCod());
        SInstance draftInstance = this.getSInstance(draft.getForm());
        boolean isFirstVersion = formRequirementEntity.getForm() == null;
        SInstance formInstance = isFirstVersion ? this.createInstance(this.loadRefType(RequirementUtil.getTypeName(draft)), null, false) : this.getSInstance(formRequirementEntity.getForm());
        Integer userCod = this.userService.getUserCodIfAvailable();
        FormKey key = isFirstVersion ? this.formPersistenceService.insert(formInstance, userCod) : this.formPersistenceService.newVersion(formInstance, userCod);
        FormRequirementService.copyValuesAndAnnotations(draftInstance.getDocument(), formInstance.getDocument());
        this.formPersistenceService.update(formInstance, userCod);
        FormEntity formEntity = this.formPersistenceService.loadFormEntity(key);
        formRequirementEntity.setForm(formEntity);
        formRequirementEntity.setCurrentDraftEntity(null);
        formInstance.getDocument().persistFiles();
        this.deassociateFormVersions(draft.getForm());
        this.draftDAO.delete(draft);
        this.formRequirementDAO.save(formRequirementEntity);
        this.formFieldService.saveFields(formInstance, formEntity.getFormType(), formEntity.getCurrentFormVersionEntity());
        return formRequirementEntity.getForm();
    }

    public void deassociateFormVersions(FormEntity form) {
        if (form != null) {
            form.setCurrentFormVersionEntity(null);
            this.formDAO.saveOrUpdate(form);
            List fves = this.formVersionDAO.findVersions(form);
            if (!CollectionUtils.isEmpty((Collection)fves)) {
                for (FormVersionEntity fve : fves) {
                    this.deleteFormVersion(fve);
                }
            }
        }
    }

    private void deleteFormVersion(FormVersionEntity fve) {
        if (fve != null) {
            if (!CollectionUtils.isEmpty((Collection)fve.getFormAnnotations())) {
                Iterator it = fve.getFormAnnotations().iterator();
                while (it.hasNext()) {
                    FormAnnotationEntity fae = (FormAnnotationEntity)it.next();
                    this.deleteAnnotation(fae);
                    it.remove();
                }
            }
            this.formAttachmentDAO.findFormAttachmentByFormVersionCod(fve.getCod()).forEach(this::deleteFormAttachmentEntity);
            this.formVersionDAO.delete(fve);
        }
    }

    private void deleteFormAttachmentEntity(FormAttachmentEntity fae) {
        this.formAttachmentDAO.delete(fae);
    }

    private void deleteAnnotation(FormAnnotationEntity fae) {
        if (fae != null) {
            FormAnnotationVersionEntity formAnnotationVersionEntity = fae.getAnnotationCurrentVersion();
            fae.setAnnotationCurrentVersion(null);
            this.formAnnotationDAO.saveOrUpdate(fae);
            this.deleteAnnotationVersion(formAnnotationVersionEntity);
            if (!CollectionUtils.isEmpty((Collection)fae.getAnnotationVersions())) {
                Iterator it = fae.getAnnotationVersions().iterator();
                while (it.hasNext()) {
                    FormAnnotationVersionEntity fave = (FormAnnotationVersionEntity)it.next();
                    this.deleteAnnotationVersion(fave);
                    it.remove();
                }
            }
            this.formAnnotationDAO.delete(fae);
        }
    }

    private void deleteAnnotationVersion(FormAnnotationVersionEntity fave) {
        this.formAnnotationVersionDAO.delete(fave);
    }

    private static void copyValuesAndAnnotations(SDocument source, SDocument target) {
        target.initRestoreMode();
        Value.copyValues((SDocument)source, (SDocument)target);
        FormRequirementService.copyIdValues(source.getRoot(), target.getRoot());
        target.setLastId(source.getLastId());
        target.getDocumentAnnotations().copyAnnotationsFrom(source);
        target.finishRestoreMode();
    }

    private static void copyIdValues(SInstance source, SInstance target) {
        block4: {
            block3: {
                target.setId(source.getId());
                if (!(source instanceof SIComposite)) break block3;
                SIComposite sourceComposite = (SIComposite)source;
                SIComposite targetComposite = (SIComposite)target;
                for (int i = 0; i < sourceComposite.getFields().size(); ++i) {
                    FormRequirementService.copyIdValues(sourceComposite.getField(i), targetComposite.getField(i));
                }
                break block4;
            }
            if (!(source instanceof SIList)) break block4;
            SIList sourceList = (SIList)source;
            SIList targetList = (SIList)target;
            if (sourceList.getChildren() != null) {
                for (int i = 0; i < sourceList.getChildren().size(); ++i) {
                    SInstance sourceItem = (SInstance)sourceList.getChildren().get(i);
                    SInstance targetItem = (SInstance)targetList.getChildren().get(i);
                    FormRequirementService.copyIdValues(sourceItem, targetItem);
                }
            }
        }
    }

    public void removeFormRequirementEntity(@Nonnull RequirementInstance p, @Nonnull Class<? extends SType<?>> type) {
        TaskInstance task = p.getFlowInstance().getCurrentTaskOrException();
        Optional<FormRequirementEntity> formRequirementEntity = this.findFormRequirementEntityByTypeAndTask(p, type, task);
        formRequirementEntity.ifPresent(x -> {
            p.getEntity().getFormRequirementEntities().remove(x);
            this.formRequirementDAO.delete((BaseEntity)x);
        });
    }

    public FormVersionHistoryEntity createFormVersionHistory(RequirementContentHistoryEntity contentHistory, FormRequirementEntity formRequirement) {
        FormVersionHistoryEntity formVersionHistoryEntity = new FormVersionHistoryEntity();
        FormEntity currentFormEntity = this.formPersistenceService.loadFormEntity(this.formKeyFromFormEntity(formRequirement.getForm()));
        formVersionHistoryEntity.setMainForm(formRequirement.getMainForm());
        formVersionHistoryEntity.setCodFormVersion(currentFormEntity.getCurrentFormVersionEntity().getCod());
        formVersionHistoryEntity.setCodRequirementContentHistory(contentHistory.getCod());
        formVersionHistoryEntity.setFormVersion(currentFormEntity.getCurrentFormVersionEntity());
        formVersionHistoryEntity.setRequirementContentHistory(contentHistory);
        return formVersionHistoryEntity;
    }

    @Nonnull
    public FormKey formKeyFromFormEntity(@Nonnull FormEntity formEntity) {
        return this.formPersistenceService.keyFromObject((Object)formEntity.getCod());
    }

    @Nonnull
    private SDocumentFactory getFactory(@Nullable SDocumentConsumer extraFactorySetupSteps) {
        SFormConfig<String> form = this.singularFormConfig.orElseThrow(() -> new SingularServerException("singularFormConfig n\u00e3o encontrado !"));
        if (extraFactorySetupSteps != null) {
            return form.getDocumentFactory().extendAddingSetupStep((IConsumer)extraFactorySetupSteps);
        }
        return form.getDocumentFactory();
    }

    @Nonnull
    public SInstance newTransientSInstance(@Nonnull FormKey formKey, @Nonnull RefType refType, boolean keepAnnotations) {
        return this.newTransientSInstance(formKey, refType, keepAnnotations, null);
    }

    @Nonnull
    public SInstance newTransientSInstance(@Nonnull FormKey formKey, @Nonnull RefType refType, boolean keepAnnotations, @Nullable SDocumentConsumer extraFactorySetupSteps) {
        return this.formPersistenceService.newTransientSInstance(formKey, refType, this.getFactory(extraFactorySetupSteps), keepAnnotations);
    }

    @Nonnull
    public SInstance createInstance(@Nonnull RefType refType) {
        return this.createInstance(refType, null);
    }

    @Nonnull
    public SInstance createInstance(@Nonnull RefType refType, @Nullable SDocumentConsumer extraFactorySetupSteps) {
        return this.createInstance(refType, extraFactorySetupSteps, true);
    }

    private SInstance createInstance(@Nonnull RefType refType, @Nullable SDocumentConsumer extraFactorySetupSteps, boolean init) {
        return this.getFactory(extraFactorySetupSteps).createInstance(refType, init);
    }

    @Nonnull
    public String extractContentXml(@Nonnull SInstance instance) {
        return SFormXMLUtil.toStringXMLOrEmptyXML((SInstance)instance);
    }

    @Nonnull
    public FormVersionEntity loadFormVersionEntity(@Nonnull Long versionId) {
        return this.formPersistenceService.loadFormVersionEntity(versionId);
    }

    public void update(@Nonnull SInstance instance, Integer inclusionActor) {
        this.formPersistenceService.update(instance, inclusionActor);
    }

    @Nonnull
    public Optional<FormEntity> findFormEntity(@Nonnull SInstance instance) {
        return this.formPersistenceService.findFormEntity(instance);
    }

    @Nonnull
    public RefType loadRefType(@Nonnull String typeName) {
        if (this.singularFormConfig.isPresent()) {
            return this.singularFormConfig.get().getTypeLoader().loadRefTypeOrException((Serializable)((Object)Objects.requireNonNull(typeName)));
        }
        throw new SingularServerException("singularFormConfig n\u00e3o encontrado !");
    }

    @Nonnull
    public RefType loadRefType(@Nonnull Class<? extends SType<?>> typeClass) {
        return this.loadRefType(RequirementUtil.getTypeName(Objects.requireNonNull(typeClass)));
    }
}

