/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.persistence.util.SqlUtil;
import org.opensingular.server.commons.admin.healthsystem.validation.database.IValidatorDatabase;
import org.opensingular.server.commons.admin.healthsystem.validation.database.ValidatorFactory;
import org.opensingular.server.commons.persistence.dao.HealthSystemDAO;
import org.opensingular.server.commons.persistence.dto.healthsystem.ColumnInfoDTO;
import org.opensingular.server.commons.persistence.dto.healthsystem.HealthInfoDTO;
import org.opensingular.server.commons.persistence.dto.healthsystem.TableInfoDTO;
import org.springframework.stereotype.Service;

@Service
public class HealthSystemDbService
implements Loggable {
    @Inject
    private HealthSystemDAO saudeDao;

    public HealthInfoDTO getAllDbMetaData() {
        ArrayList<TableInfoDTO> tables = new ArrayList<TableInfoDTO>();
        try {
            Map<String, ClassMetadata> map = this.saudeDao.getAllDbMetaData();
            map.forEach((k, v) -> tables.add(this.getTableInfo((AbstractEntityPersister)v)));
            Optional<IValidatorDatabase> validator = this.verificaDialetoUtilizado();
            if (validator.isPresent()) {
                validator.get().checkAllInfoTable(tables);
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            tables.clear();
        }
        return new HealthInfoDTO(tables);
    }

    private TableInfoDTO getTableInfo(AbstractEntityPersister persister) {
        TableInfoDTO tableInfoDTO = new TableInfoDTO();
        String[] name = SqlUtil.replaceSingularSchemaName((String)persister.getTableName()).split("\\.");
        tableInfoDTO.setSchema(name[0]);
        tableInfoDTO.setTableName(name[1]);
        ArrayList columns = new ArrayList();
        String[] propertyNames = persister.getPropertyNames();
        Arrays.asList(propertyNames).forEach(propertyName -> columns.add(persister.getPropertyColumnNames(propertyName)[0]));
        Arrays.asList(persister.getIdentifierColumnNames()).forEach(chave -> {
            if (!columns.contains(chave)) {
                columns.add(chave);
            }
        });
        ArrayList<ColumnInfoDTO> columnsType = new ArrayList<ColumnInfoDTO>();
        columns.forEach(col -> columnsType.add(new ColumnInfoDTO((String)col, true)));
        tableInfoDTO.setColumnsInfo(columnsType);
        return tableInfoDTO;
    }

    private Optional<IValidatorDatabase> verificaDialetoUtilizado() {
        String hibernateDialect = this.saudeDao.getHibernateDialect();
        return Optional.ofNullable(ValidatorFactory.getValidator(hibernateDialect));
    }
}

