/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opensingular.flow.core.Flow;
import org.opensingular.flow.core.FlowDefinition;
import org.opensingular.flow.core.FlowInstance;
import org.opensingular.flow.core.TaskInstance;
import org.opensingular.flow.persistence.entity.FlowDefinitionEntity;
import org.opensingular.flow.persistence.entity.FlowInstanceEntity;
import org.opensingular.flow.persistence.entity.FlowVersionEntity;
import org.opensingular.form.SIComposite;
import org.opensingular.form.SInstance;
import org.opensingular.form.SType;
import org.opensingular.form.SingularFormException;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.opensingular.server.commons.exception.SingularRequirementException;
import org.opensingular.server.commons.persistence.entity.enums.PersonType;
import org.opensingular.server.commons.persistence.entity.form.ApplicantEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.service.FormRequirementService;
import org.opensingular.server.commons.service.RequirementService;
import org.opensingular.server.commons.service.RequirementUtil;

public class RequirementInstance
implements Serializable {
    private final RequirementEntity requirementEntity;
    private transient FlowInstance flowInstance;
    private transient SIComposite mainForm;

    public RequirementInstance(RequirementEntity requirementEntity) {
        this.requirementEntity = Objects.requireNonNull(requirementEntity);
    }

    public FlowInstance getFlowInstance() {
        if (this.flowInstance == null && this.requirementEntity.getFlowInstanceEntity() != null) {
            this.flowInstance = RequirementUtil.getFlowInstance(this.requirementEntity);
        }
        return this.flowInstance;
    }

    final void setFlowInstance(FlowInstance flowInstance) {
        this.flowInstance = flowInstance;
    }

    public boolean isFlowInstanceCreated() {
        return this.requirementEntity.getFlowInstanceEntity() != null;
    }

    @Nonnull
    public SIComposite getMainForm() {
        if (this.mainForm == null) {
            this.mainForm = this.getRequirementService().getMainFormAsInstance(this.requirementEntity);
        }
        return this.mainForm;
    }

    @Nonnull
    public <I extends SInstance, K extends SType<? extends I>> I getMainForm(@Nonnull Class<K> expectedType) {
        return FormRequirementService.checkIfExpectedType((SInstance)this.getMainForm(), expectedType);
    }

    @Nonnull
    public <I extends SInstance> I getMainFormAndCast(@Nonnull Class<I> expectedType) {
        SIComposite i = this.getMainForm();
        if (expectedType.isAssignableFrom(i.getClass())) {
            return (I)i;
        }
        throw new SingularFormException("Era esperado a inst\u00e2ncia recuperada fosse do tipo " + expectedType.getName() + " mas ela \u00e9 do tipo " + i.getClass(), (SInstance)i);
    }

    @Nonnull
    private RequirementService<?, ?> getRequirementService() {
        return (RequirementService)ApplicationContextProvider.get().getBean(RequirementService.class);
    }

    public FlowDefinition<?> getFlowDefinition() {
        return RequirementUtil.getFlowDefinition(this.requirementEntity);
    }

    public void setFlowDefinition(@Nonnull Class<? extends FlowDefinition> clazz) {
        FlowDefinition flowDefinition = Flow.getFlowDefinition(clazz);
        this.requirementEntity.setFlowDefinitionEntity((FlowDefinitionEntity)flowDefinition.getEntityFlowDefinition());
    }

    public Optional<FlowDefinition<?>> getFlowDefinitionOpt() {
        return RequirementUtil.getFlowDefinitionOpt(this.requirementEntity);
    }

    public Long getCod() {
        return this.requirementEntity.getCod();
    }

    public TaskInstance getCurrentTaskOrException() {
        return this.getFlowInstance().getCurrentTaskOrException();
    }

    public String getCurrentTaskNameOrException() {
        return this.getFlowInstance().getCurrentTaskOrException().getName();
    }

    @Nonnull
    public Optional<RequirementInstance> getParentRequirement() {
        return Optional.ofNullable(this.requirementEntity.getParentRequirement()).map(parent -> this.getRequirementService().newRequirementInstance(parent));
    }

    @Nonnull
    public RequirementInstance getParentRequirementOrException() {
        return this.getParentRequirement().orElseThrow(() -> new SingularRequirementException("A peti\u00e7\u00e3o pai est\u00e1 null para esse requerimento", this));
    }

    public String getDescription() {
        return this.requirementEntity.getDescription();
    }

    public void setDescription(String description) {
        this.requirementEntity.setDescription(description);
    }

    public void setNewFlow(FlowInstance newFlowInstance) {
        FlowInstanceEntity flowEntity = (FlowInstanceEntity)newFlowInstance.saveEntity();
        this.requirementEntity.setFlowInstanceEntity(flowEntity);
        this.requirementEntity.setFlowDefinitionEntity((FlowDefinitionEntity)((FlowVersionEntity)flowEntity.getFlowVersion()).getFlowDefinition());
    }

    public FlowInstance startNewFlow(@Nonnull FlowDefinition flowDefinition) {
        this.flowInstance = this.getRequirementService().startNewFlow(this, flowDefinition, null);
        return this.flowInstance;
    }

    public RequirementEntity getEntity() {
        return this.requirementEntity;
    }

    public ApplicantEntity getApplicant() {
        return this.requirementEntity.getApplicant();
    }

    public String getIdPessoaSeForPessoaJuridica() {
        if (PersonType.JURIDICA == this.getApplicant().getPersonType()) {
            return this.getApplicant().getIdPessoa();
        }
        return null;
    }

    public FormVersionEntity getMainFormCurrentFormVersion() {
        return this.requirementEntity.getMainForm().getCurrentFormVersionEntity();
    }

    public Long getMainFormCurrentFormVersionCod() {
        return this.getMainFormCurrentFormVersion().getCod();
    }

    public String getMainFormTypeName() {
        return this.getEntity().getMainForm().getFormType().getAbbreviation();
    }

    public String getRequirementDefinitionName() {
        return this.getEntity().getRequirementDefinitionEntity().getName();
    }

    public String getApplicantName() {
        return Optional.of(this.getEntity()).map(RequirementEntity::getApplicant).map(ApplicantEntity::getName).orElse(null);
    }
}

