/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.collections.CollectionUtils;
import org.opensingular.flow.core.Flow;
import org.opensingular.flow.core.FlowDefinition;
import org.opensingular.flow.core.FlowInstance;
import org.opensingular.flow.core.STransition;
import org.opensingular.flow.core.SUser;
import org.opensingular.flow.core.TaskInstance;
import org.opensingular.flow.core.TransitionCall;
import org.opensingular.flow.persistence.dao.ModuleDAO;
import org.opensingular.flow.persistence.entity.Actor;
import org.opensingular.flow.persistence.entity.FlowDefinitionEntity;
import org.opensingular.flow.persistence.entity.FlowInstanceEntity;
import org.opensingular.flow.persistence.entity.FlowVersionEntity;
import org.opensingular.flow.persistence.entity.ModuleEntity;
import org.opensingular.flow.persistence.entity.TaskInstanceEntity;
import org.opensingular.form.SIComposite;
import org.opensingular.form.SInstance;
import org.opensingular.form.SType;
import org.opensingular.form.persistence.FormKey;
import org.opensingular.form.persistence.entity.FormAnnotationEntity;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.util.FormatUtil;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.persistence.dao.flow.ActorDAO;
import org.opensingular.server.commons.persistence.dao.flow.TaskInstanceDAO;
import org.opensingular.server.commons.persistence.dao.form.ApplicantDAO;
import org.opensingular.server.commons.persistence.dao.form.RequirementContentHistoryDAO;
import org.opensingular.server.commons.persistence.dao.form.RequirementDAO;
import org.opensingular.server.commons.persistence.dao.form.RequirementDefinitionDAO;
import org.opensingular.server.commons.persistence.dto.RequirementHistoryDTO;
import org.opensingular.server.commons.persistence.entity.enums.PersonType;
import org.opensingular.server.commons.persistence.entity.form.ApplicantEntity;
import org.opensingular.server.commons.persistence.entity.form.FormRequirementEntity;
import org.opensingular.server.commons.persistence.entity.form.FormVersionHistoryEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementContentHistoryEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementDefinitionEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.persistence.filter.QuickFilter;
import org.opensingular.server.commons.persistence.requirement.RequirementSearchExtender;
import org.opensingular.server.commons.service.FormRequirementService;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.service.RequirementUtil;
import org.opensingular.server.commons.spring.security.AuthorizationService;
import org.opensingular.server.commons.spring.security.RequirementAuthMetadataDTO;
import org.opensingular.server.commons.spring.security.SingularPermission;
import org.opensingular.server.commons.spring.security.SingularUserDetails;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class RequirementService<RE extends RequirementEntity, RI extends RequirementInstance>
implements Loggable {
    @Inject
    protected RequirementDAO<RE> requirementDAO;
    @Inject
    protected ModuleDAO moduleDAO;
    @Inject
    protected TaskInstanceDAO taskInstanceDAO;
    @Inject
    protected ApplicantDAO applicantDAO;
    @Inject
    protected AuthorizationService authorizationService;
    @Inject
    protected ActorDAO actorDAO;
    @Inject
    private RequirementContentHistoryDAO requirementContentHistoryDAO;
    @Inject
    private FormRequirementService<RE> formRequirementService;
    @Inject
    private RequirementDefinitionDAO<RequirementDefinitionEntity> requirementDefinitionDAO;
    @Inject
    private Provider<SingularUserDetails> singularUserDetails;

    protected SingularUserDetails getSingularUserDetails() {
        return (SingularUserDetails)this.singularUserDetails.get();
    }

    @Nonnull
    protected abstract RI newRequirementInstance(@Nonnull RE var1);

    @Nonnull
    protected abstract RE newRequirementEntityFor(RequirementDefinitionEntity var1);

    @Nonnull
    private RI getRequirementInstance(@Nonnull RE requirementEntity) {
        Objects.requireNonNull(requirementEntity);
        return this.newRequirementInstance(requirementEntity);
    }

    @Nonnull
    public RI getRequirementInstance(@Nonnull FlowInstance flowInstance) {
        Objects.requireNonNull(flowInstance);
        RI instance = this.getRequirementInstance(this.getRequirementByFlowCod(flowInstance.getEntityCod()));
        ((RequirementInstance)instance).setFlowInstance(flowInstance);
        return instance;
    }

    @Nonnull
    public RI getRequirementInstance(@Nonnull TaskInstance taskInstance) {
        Objects.requireNonNull(taskInstance);
        return this.getRequirementInstance(taskInstance.getFlowInstance());
    }

    @Nonnull
    protected FormRequirementService<RE> getFormRequirementService() {
        return Objects.requireNonNull(this.formRequirementService);
    }

    protected void configureApplicant(RI requirement) {
        UserDetails userDetails = (UserDetails)this.singularUserDetails.get();
        if (userDetails instanceof SingularUserDetails) {
            ApplicantEntity p = this.applicantDAO.findApplicantByExternalId(userDetails.getUsername());
            if (p == null) {
                p = new ApplicantEntity();
                p.setIdPessoa(userDetails.getUsername());
                p.setName(((SingularUserDetails)userDetails).getDisplayName());
                p.setPersonType(PersonType.FISICA);
            }
            ((RequirementInstance)requirement).getEntity().setApplicant(p);
        } else {
            this.getLogger().error(" The applicant (current logged user, {}) for requirement: \"{}\" could not be identified ", (Object)SingularUserDetails.class.getSimpleName(), (Object)((RequirementInstance)requirement).getRequirementDefinitionName());
        }
    }

    @Nonnull
    private Optional<RE> findRequirementByCod(@Nonnull Long cod) {
        Objects.requireNonNull(cod);
        return this.requirementDAO.find(cod);
    }

    @Nonnull
    public Optional<RI> findRequirement(@Nonnull Long cod) {
        Objects.requireNonNull(cod);
        return this.requirementDAO.find(cod).map(this::newRequirementInstance);
    }

    @Nonnull
    @Deprecated
    public RE getRequirementByCod(@Nonnull Long cod) {
        return (RE)((Object)((RequirementEntity)((Object)this.findRequirementByCod(cod).orElseThrow(() -> SingularServerException.rethrow("N\u00e3o foi encontrada a peti\u00e7\u00e3o de cod=" + cod)))));
    }

    @Nonnull
    public RI getRequirement(@Nonnull Long cod) {
        return (RI)((RequirementInstance)this.findRequirement(cod).orElseThrow(() -> SingularServerException.rethrow("N\u00e3o foi encontrada a peti\u00e7\u00e3o de cod=" + cod)));
    }

    @Nonnull
    @Deprecated
    public RE getRequirementByFlowCod(@Nonnull Integer cod) {
        Objects.requireNonNull(cod);
        return this.requirementDAO.findByFlowCodOrException(cod);
    }

    @Nonnull
    public RI getRequirement(@Nonnull FlowInstance flowInstance) {
        Objects.requireNonNull(flowInstance);
        RE requirement = this.getRequirementByFlowCod(flowInstance.getEntityCod());
        return this.newRequirementInstance(requirement);
    }

    @Nonnull
    public RI getRequirement(@Nonnull TaskInstance taskInstance) {
        Objects.requireNonNull(taskInstance);
        return this.getRequirement(taskInstance.getFlowInstance());
    }

    public void deleteRequirement(@Nonnull Long idRequirement) {
        this.requirementDAO.find(idRequirement).ifPresent(re -> this.requirementDAO.delete((RE)((Object)re)));
    }

    public Long countQuickSearch(QuickFilter filter) {
        return this.countQuickSearch(filter, Collections.emptyList());
    }

    public Long countQuickSearch(QuickFilter filter, List<RequirementSearchExtender> extenders) {
        return this.requirementDAO.countQuickSearch(filter, extenders);
    }

    public List<Map<String, Serializable>> quickSearchMap(QuickFilter filter) {
        return this.quickSearchMap(filter, Collections.emptyList());
    }

    public List<Map<String, Serializable>> quickSearchMap(QuickFilter filter, List<RequirementSearchExtender> extenders) {
        return this.requirementDAO.quickSearchMap(filter, extenders);
    }

    @Nonnull
    public FormKey saveOrUpdate(@Nonnull RI requirement, @Nonnull SInstance instance, boolean mainForm) {
        Objects.requireNonNull(requirement);
        Objects.requireNonNull(instance);
        this.requirementDAO.saveOrUpdate(((RequirementInstance)requirement).getEntity());
        if (((RequirementInstance)requirement).getApplicant() != null) {
            this.applicantDAO.saveOrUpdate(((RequirementInstance)requirement).getApplicant());
        }
        return this.formRequirementService.saveFormRequirement((RequirementInstance)requirement, instance, mainForm);
    }

    public void onAfterStartFlow(RI requirement, SInstance instance, String codSubmitterActor, FlowInstance flowInstance) {
    }

    public void onBeforeStartFlow(RI requirement, SInstance instance, String codSubmitterActor) {
    }

    public void saveRequirementHistory(RequirementInstance requirement, List<FormEntity> newEntities) {
        Optional<TaskInstanceEntity> taskInstance = this.findCurrentTaskEntityByRequirementId(requirement.getCod());
        FormEntity formEntity = requirement.getEntity().getMainForm();
        this.getLogger().info("Atualizando hist\u00f3rico da peti\u00e7\u00e3o.");
        RequirementContentHistoryEntity contentHistoryEntity = new RequirementContentHistoryEntity();
        contentHistoryEntity.setRequirementEntity(requirement.getEntity());
        if (taskInstance.isPresent()) {
            contentHistoryEntity.setActor((Actor)taskInstance.get().getAllocatedUser());
            contentHistoryEntity.setTaskInstanceEntity(taskInstance.get());
        }
        if (CollectionUtils.isNotEmpty((Collection)formEntity.getCurrentFormVersionEntity().getFormAnnotations())) {
            contentHistoryEntity.setFormAnnotationsVersions(formEntity.getCurrentFormVersionEntity().getFormAnnotations().stream().map(FormAnnotationEntity::getAnnotationCurrentVersion).collect(Collectors.toList()));
        }
        contentHistoryEntity.setApplicantEntity(requirement.getApplicant());
        contentHistoryEntity.setHistoryDate(new Date());
        this.requirementContentHistoryDAO.saveOrUpdate(contentHistoryEntity);
        contentHistoryEntity.setFormVersionHistoryEntities(requirement.getEntity().getFormRequirementEntities().stream().filter(fpe -> newEntities.contains(fpe.getForm())).map(f -> this.formRequirementService.createFormVersionHistory(contentHistoryEntity, (FormRequirementEntity)f)).collect(Collectors.toList()));
    }

    public void executeTransition(String transitionName, RI requirement, BiConsumer<RI, String> transitionListener, Map<String, String> processParameters, Map<String, String> transitionParameters) {
        try {
            if (transitionListener != null) {
                transitionListener.accept(requirement, transitionName);
            }
            this.saveRequirementHistory((RequirementInstance)requirement, this.formRequirementService.consolidateDrafts((RequirementInstance)requirement));
            FlowInstance flowInstance = ((RequirementInstance)requirement).getFlowInstance();
            if (processParameters != null && !processParameters.isEmpty()) {
                for (Map.Entry<String, String> entry : processParameters.entrySet()) {
                    flowInstance.getVariables().addValueString(entry.getKey(), entry.getValue());
                }
            }
            TransitionCall transitionCall = flowInstance.prepareTransition(transitionName);
            if (transitionParameters != null && !transitionParameters.isEmpty()) {
                for (Map.Entry<String, String> transitionParameter : transitionParameters.entrySet()) {
                    transitionCall.addValueString(transitionParameter.getKey(), transitionParameter.getValue());
                }
            }
            transitionCall.go();
        }
        catch (SingularException e) {
            throw e;
        }
        catch (Exception e) {
            throw SingularServerException.rethrow(e.getMessage(), e);
        }
    }

    public List<Map<String, Serializable>> listTasks(QuickFilter filter, List<SingularPermission> permissions) {
        return this.listTasks(filter, this.authorizationService.filterListTaskPermissions(permissions), Collections.emptyList());
    }

    public Long countTasks(QuickFilter filter, List<SingularPermission> permissions) {
        return this.countTasks(filter, this.authorizationService.filterListTaskPermissions(permissions), Collections.emptyList());
    }

    public List<Map<String, Serializable>> listTasks(QuickFilter filter, List<SingularPermission> permissions, List<RequirementSearchExtender> extenders) {
        return this.requirementDAO.quickSearchMap(filter, this.authorizationService.filterListTaskPermissions(permissions), extenders);
    }

    public Long countTasks(QuickFilter filter, List<SingularPermission> permissions, List<RequirementSearchExtender> extenders) {
        return this.requirementDAO.countQuickSearch(filter, this.authorizationService.filterListTaskPermissions(permissions), extenders);
    }

    public Optional<TaskInstance> findCurrentTaskInstanceByRequirementId(Long requirementId) {
        return this.findCurrentTaskEntityByRequirementId(requirementId).map(Flow::getTaskInstance);
    }

    @Nonnull
    public Optional<TaskInstanceEntity> findCurrentTaskEntityByRequirementId(@Nonnull Long requirementId) {
        Objects.requireNonNull(requirementId);
        List<TaskInstanceEntity> taskInstances = this.taskInstanceDAO.findCurrentTasksByRequirementId(requirementId);
        if (taskInstances.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(taskInstances.get(0));
    }

    public List<ModuleEntity> listAllModules() {
        return this.moduleDAO.listAll();
    }

    public ModuleEntity findByModuleCod(String cod) {
        return this.moduleDAO.get((Serializable)((Object)cod)).orElse(null);
    }

    @Nonnull
    public RI createNewRequirementWithoutSave(@Nullable Class<? extends FlowDefinition> classFlowDefinition, @Nullable RI parentRequirement, @Deprecated @Nullable Consumer<RI> creationListener, RequirementDefinitionEntity requirementDefinitionEntity) {
        RE requirementEntity = this.newRequirementEntityFor(requirementDefinitionEntity);
        if (classFlowDefinition != null) {
            ((RequirementEntity)((Object)requirementEntity)).setFlowDefinitionEntity((FlowDefinitionEntity)Flow.getFlowDefinition(classFlowDefinition).getEntityFlowDefinition());
        }
        if (parentRequirement != null) {
            RequirementEntity parentRequirementEntity = ((RequirementInstance)parentRequirement).getEntity();
            ((RequirementEntity)((Object)requirementEntity)).setParentRequirement(parentRequirementEntity);
            if (parentRequirementEntity.getRootRequirement() != null) {
                ((RequirementEntity)((Object)requirementEntity)).setRootRequirement(parentRequirementEntity.getRootRequirement());
            } else {
                ((RequirementEntity)((Object)requirementEntity)).setRootRequirement(parentRequirementEntity);
            }
        }
        RI requirement = this.newRequirementInstance(requirementEntity);
        this.configureApplicant(requirement);
        if (creationListener != null) {
            creationListener.accept(requirement);
        }
        return requirement;
    }

    public List<RequirementHistoryDTO> listRequirementContentHistoryByCodRequirement(long codRequirement, String menu, boolean filter) {
        RequirementEntity requirement = (RequirementEntity)this.requirementDAO.findOrException(Long.valueOf(codRequirement));
        return this.requirementContentHistoryDAO.listRequirementContentHistoryByCodRequirement(requirement, menu, filter);
    }

    public List<Actor> listAllowedUsers(Map<String, Object> selectedTask) {
        Integer taskInstanceId = Integer.valueOf(String.valueOf(selectedTask.get("taskInstanceId")));
        return this.actorDAO.listAllowedUsers(taskInstanceId);
    }

    public ApplicantEntity findApplicantByExternalId(String externalId) {
        return this.applicantDAO.findApplicantByExternalId(externalId);
    }

    @Nonnull
    public boolean isPreviousTransition(@Nonnull TaskInstance taskInstance, @Nonnull String trasitionName) {
        Optional executedTransition = taskInstance.getFlowInstance().getLastFinishedTask().map(TaskInstance::getExecutedTransition).orElse(Optional.empty());
        if (executedTransition.isPresent()) {
            STransition transition = (STransition)executedTransition.get();
            return trasitionName.equals(transition.getName());
        }
        return false;
    }

    public RequirementAuthMetadataDTO findRequirementAuthMetadata(Long requirementId) {
        return this.requirementDAO.findRequirementAuthMetadata(requirementId);
    }

    public List<FormVersionEntity> buscarDuasUltimasVersoesForm(@Nonnull Long codRequirement) {
        RequirementEntity requirementEntity = (RequirementEntity)this.requirementDAO.findOrException(codRequirement);
        FormEntity mainForm = requirementEntity.getMainForm();
        return this.formRequirementService.findTwoLastFormVersions(mainForm.getCod());
    }

    public Optional<FlowInstanceEntity> getFormFlowInstanceEntity(@Nonnull SInstance instance) {
        return this.getFormRequirementService().findFormEntity(instance).map(formEntity -> this.requirementDAO.findByFormEntity((FormEntity)formEntity)).map(RequirementEntity::getFlowInstanceEntity);
    }

    public boolean formHasFlowInstance(SInstance instance) {
        return this.getFormFlowInstanceEntity(instance).isPresent();
    }

    @Nonnull
    public SIComposite getMainFormAsInstance(@Nonnull RequirementEntity requirement) {
        Objects.requireNonNull(requirement);
        return (SIComposite)this.getFormRequirementService().getSInstance(requirement.getMainForm());
    }

    @Nonnull
    public <I extends SInstance, K extends SType<? extends I>> I getMainFormAsInstance(@Nonnull RequirementEntity requirement, @Nonnull Class<K> expectedType) {
        Objects.requireNonNull(requirement);
        return this.getFormRequirementService().getSInstance(requirement.getMainForm(), expectedType);
    }

    @Nonnull
    public Optional<FormRequirementEntity> findLastFormRequirementEntityByType(@Nonnull RequirementInstance requirement, @Nonnull Class<? extends SType<?>> typeClass) {
        return this.getFormRequirementService().findLastFormRequirementEntityByType(requirement, typeClass);
    }

    @Nonnull
    public Optional<SInstance> findLastFormRequirementInstanceByType(@Nonnull RequirementInstance requirement, @Nonnull Class<? extends SType<?>> typeClass) {
        return this.getFormRequirementService().findLastFormRequirementInstanceByType(requirement, typeClass);
    }

    @Nonnull
    public Optional<SIComposite> findLastFormInstanceByType(@Nonnull RequirementInstance requirement, @Nonnull Class<? extends SType<?>> typeClass) {
        Objects.requireNonNull(requirement);
        return this.requirementContentHistoryDAO.findLastByCodRequirementAndType(typeClass, requirement.getCod()).map(FormVersionHistoryEntity::getFormVersion).map(version -> (SIComposite)this.getFormRequirementService().getSInstance((FormVersionEntity)version));
    }

    @Nonnull
    protected Optional<SIComposite> findLastFormInstanceByType(@Nonnull RequirementInstance requirement, @Nonnull Collection<Class<? extends SType<?>>> typesClass) {
        Objects.requireNonNull(requirement);
        FormVersionHistoryEntity max = null;
        for (Class<SType<?>> clazz : typesClass) {
            Optional<FormVersionHistoryEntity> result = this.requirementContentHistoryDAO.findLastByCodRequirementAndType(clazz, requirement.getCod());
            if (!result.isPresent() || max != null && !max.getRequirementContentHistory().getHistoryDate().before(result.get().getRequirementContentHistory().getHistoryDate())) continue;
            max = result.get();
        }
        return Optional.ofNullable(max).map(version -> (SIComposite)this.getFormRequirementService().getSInstance(version.getFormVersion()));
    }

    @Nonnull
    public FlowInstance startNewFlow(@Nonnull RequirementInstance requirement, @Nonnull FlowDefinition flowDefinition, @Nullable String codSubmitterActor) {
        FlowInstance newFlowInstance = flowDefinition.newPreStartInstance();
        newFlowInstance.setDescription(requirement.getDescription());
        FlowInstanceEntity flowEntity = (FlowInstanceEntity)newFlowInstance.saveEntity();
        if (codSubmitterActor != null) {
            RequirementUtil.findUser(codSubmitterActor).filter(u -> u instanceof Actor).ifPresent(user -> flowEntity.setUserCreator((SUser)((Actor)user)));
        }
        RequirementEntity requirementEntity = requirement.getEntity();
        requirementEntity.setFlowInstanceEntity(flowEntity);
        requirementEntity.setFlowDefinitionEntity((FlowDefinitionEntity)((FlowVersionEntity)flowEntity.getFlowVersion()).getFlowDefinition());
        this.requirementDAO.saveOrUpdate(requirementEntity);
        newFlowInstance.start();
        requirement.setFlowInstance(newFlowInstance);
        return newFlowInstance;
    }

    @Deprecated
    public boolean containChildren(Long codRequirement) {
        return this.requirementDAO.containChildren(codRequirement);
    }

    public void updateRequirementDescription(SInstance currentInstance, RI requirement) {
        String description = currentInstance.toStringDisplay();
        if (description != null && description.length() > 200) {
            this.getLogger().error("Descri\u00e7\u00e3o do formul\u00e1rio muito extensa. A descri\u00e7\u00e3o foi cortada.");
            description = description.substring(0, 197) + "...";
        }
        ((RequirementInstance)requirement).setDescription(description);
    }

    public RequirementDefinitionEntity findRequirementDefinition(Long requirementId) {
        return (RequirementDefinitionEntity)this.requirementDefinitionDAO.findOrException(requirementId);
    }

    public void logTaskVisualization(RI requirement) {
        TaskInstance taskInstance = ((RequirementInstance)requirement).getFlowInstance().getCurrentTaskOrException();
        taskInstance.log("Leitura da tarefa", FormatUtil.dateToDefaultTimestampString((Date)new Date()));
    }
}

