/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opensingular.flow.core.Flow;
import org.opensingular.flow.core.FlowDefinition;
import org.opensingular.flow.core.FlowInstance;
import org.opensingular.flow.core.SUser;
import org.opensingular.flow.core.TaskInstance;
import org.opensingular.flow.core.entity.IEntityFlowInstance;
import org.opensingular.flow.core.entity.IEntityTaskDefinition;
import org.opensingular.flow.core.entity.IEntityTaskInstance;
import org.opensingular.flow.core.entity.IEntityTaskVersion;
import org.opensingular.flow.persistence.entity.FlowInstanceEntity;
import org.opensingular.form.SFormUtil;
import org.opensingular.form.SInstance;
import org.opensingular.form.SType;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.persistence.entity.FormTypeEntity;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.opensingular.server.commons.exception.RequirementWithoutDefinitionException;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.persistence.entity.form.DraftEntity;
import org.opensingular.server.commons.persistence.entity.form.FormRequirementEntity;
import org.opensingular.server.commons.persistence.entity.form.RequirementEntity;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.service.RequirementService;
import org.opensingular.server.commons.service.ServerSInstanceFlowAwareService;

public final class RequirementUtil {
    private RequirementUtil() {
    }

    @Nonnull
    public static FlowDefinition<?> getFlowDefinition(@Nonnull RequirementEntity requirement) {
        return RequirementUtil.getFlowDefinitionOpt(requirement).orElseThrow(() -> new RequirementWithoutDefinitionException().add((Object)requirement));
    }

    @Nonnull
    static final Optional<FlowDefinition<?>> getFlowDefinitionOpt(@Nonnull RequirementEntity requirement) {
        Objects.requireNonNull(requirement);
        if (requirement.getFlowDefinitionEntity() == null) {
            return Optional.empty();
        }
        return Optional.of(Flow.getFlowDefinition((String)requirement.getFlowDefinitionEntity().getKey()));
    }

    @Nonnull
    public static IEntityTaskDefinition getCurrentTaskDefinition(@Nonnull RequirementEntity requirement) {
        return RequirementUtil.getCurrentTaskDefinitionOpt(requirement).orElseThrow(() -> SingularServerException.rethrow("N\u00e3o h\u00e1 uma tarefa corrente associada \u00e0 peti\u00e7\u00e3o."));
    }

    @Nonnull
    public static Optional<IEntityTaskDefinition> getCurrentTaskDefinitionOpt(@Nonnull RequirementEntity requirement) {
        FlowInstanceEntity flowInstanceEntity = requirement.getFlowInstanceEntity();
        if (flowInstanceEntity != null) {
            return flowInstanceEntity.getCurrentTask().map(IEntityTaskInstance::getTaskVersion).map(IEntityTaskVersion::getTaskDefinition);
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<TaskInstance> getCurrentTaskEntity(@Nonnull SInstance instance) {
        return Optional.of(instance.getDocument().lookupLocalServiceOrException(ServerSInstanceFlowAwareService.class)).map(ServerSInstanceFlowAwareService::getFlowInstance).flatMap(FlowInstance::getCurrentTask);
    }

    @Nonnull
    public static FlowInstance getFlowInstance(@Nonnull RequirementEntity requirement) {
        Objects.requireNonNull(requirement);
        return Flow.getFlowInstance((IEntityFlowInstance)requirement.getFlowInstanceEntity());
    }

    @Nonnull
    public static Optional<SUser> findUser(@Nonnull String idUsuario) {
        Objects.requireNonNull(idUsuario);
        return Flow.getConfigBean().getUserService().saveUserIfNeeded(idUsuario);
    }

    @Nonnull
    public static SUser findUserOrException(@Nonnull String idUsuario) {
        return RequirementUtil.findUser(idUsuario).orElseThrow(() -> SingularServerException.rethrow("N\u00e3o foi encontrado o usu\u00e1rio").add("idUsuario", idUsuario));
    }

    @Nonnull
    public static RequirementService<?, ?> getRequirementService() {
        return (RequirementService)ApplicationContextProvider.get().getBean(RequirementService.class);
    }

    @Nonnull
    public static String getTypeName(@Nonnull RequirementInstance requirement) {
        return RequirementUtil.getTypeName(requirement.getEntity().getMainForm());
    }

    @Nonnull
    public static String getTypeName(@Nonnull RequirementEntity requirement) {
        return RequirementUtil.getTypeName(requirement.getMainForm());
    }

    @Nonnull
    public static String getTypeName(@Nonnull DraftEntity draftEntity) {
        return RequirementUtil.getTypeName(draftEntity.getForm());
    }

    @Nonnull
    public static String getTypeName(@Nonnull FormRequirementEntity formRequirementEntity) {
        return RequirementUtil.getTypeName(formRequirementEntity.getForm());
    }

    @Nonnull
    public static String getTypeName(@Nonnull FormVersionEntity formVersionEntity) {
        return RequirementUtil.getTypeName(formVersionEntity.getFormEntity());
    }

    @Nonnull
    public static String getTypeName(@Nonnull FormEntity form) {
        return RequirementUtil.getTypeName(form.getFormType());
    }

    @Nonnull
    public static String getTypeName(@Nonnull FormTypeEntity ft) {
        return ft.getAbbreviation();
    }

    @Nonnull
    public static String getTypeName(@Nonnull Class<? extends SType<?>> typeClass) {
        return SFormUtil.getTypeName(typeClass);
    }
}

