/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.app.commons.mail.service.dto.Email;
import org.opensingular.app.commons.mail.service.email.IEmailService;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.spring.security.SingularUserDetails;
import org.springframework.security.core.context.SecurityContextHolder;

@Named
public class SendEmailToSupportService
implements Loggable {
    private static final String SINGULAR_SUPPORT_ADDRESS = "singular.mail.support.address";
    @Inject
    private Provider<SingularUserDetails> singularUserDetails;
    @Inject
    private IEmailService<Email> emailService;

    @Transactional
    public void sendEmailToSupport(String errorCode, String stackTrace, String urlException) {
        String supportEmail = SingularProperties.get().getProperty(SINGULAR_SUPPORT_ADDRESS, "");
        if (StringUtils.isNotBlank((CharSequence)supportEmail)) {
            try {
                Email email = new Email();
                String[] emails = supportEmail.split(",");
                for (int i = 0; i < emails.length; ++i) {
                    emails[i] = emails[i].trim();
                }
                email.addTo(emails);
                email.withSubject("Exception in production");
                String loggedUser = this.getLoggedUser();
                email.withContent("<pre>Url: " + urlException + "\n\n" + loggedUser + "\n\nError code: " + errorCode + "\n\nStack Trace:\n\n" + stackTrace + "</pre>");
                this.emailService.send(email);
            }
            catch (SingularServerException e) {
                this.getLogger().warn("Error ocurred while send e-mail to singular support", (Throwable)((Object)e));
            }
        }
    }

    private String getLoggedUser() {
        StringBuilder returnString = new StringBuilder();
        try {
            SingularUserDetails userDetails = (SingularUserDetails)this.singularUserDetails.get();
            if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof String) {
                returnString.append("Username: ").append(SecurityContextHolder.getContext().getAuthentication().getPrincipal());
            } else if (userDetails != null) {
                returnString.append("Username: ").append(userDetails.getUsername()).append("\nDisplay name: ").append(userDetails.getDisplayName());
            } else {
                returnString.append("User: - ");
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Error ocurred while retrieving logged User", (Throwable)e);
            returnString.setLength(0);
            returnString.append("User not found");
        }
        return returnString.toString();
    }
}

