/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opensingular.form.SInstance;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.form.service.IFormService;
import org.opensingular.form.util.diff.DocumentDiff;
import org.opensingular.form.util.diff.DocumentDiffUtil;
import org.opensingular.server.commons.persistence.entity.form.DraftEntity;
import org.opensingular.server.commons.persistence.entity.form.FormRequirementEntity;
import org.opensingular.server.commons.service.FormRequirementService;
import org.opensingular.server.commons.service.RequirementInstance;
import org.opensingular.server.commons.service.RequirementService;
import org.opensingular.server.commons.service.RequirementUtil;

public class SingularDiffService {
    @Inject
    protected FormRequirementService<?> formRequirementService;
    @Inject
    protected IFormService formService;
    @Inject
    private RequirementService<?, ?> requirementService;

    public DiffSummary diffFromPrevious(@Nonnull Long requirementId) {
        Date newerDate;
        SInstance newer;
        FormVersionEntity newerFormVersion;
        FormVersionEntity originalFormVersion = null;
        Object requirement = this.requirementService.getRequirement(requirementId);
        String typeName = RequirementUtil.getTypeName(requirement);
        Optional<DraftEntity> draftEntity = ((RequirementInstance)requirement).getEntity().currentEntityDraftByType(typeName);
        SInstance original = null;
        Date originalDate = null;
        if (draftEntity.isPresent()) {
            Optional<FormRequirementEntity> lastForm = this.formRequirementService.findLastFormRequirementEntityByType((RequirementInstance)requirement, typeName);
            if (lastForm.isPresent()) {
                FormEntity originalForm = lastForm.get().getForm();
                original = this.formRequirementService.getSInstance(originalForm);
                originalFormVersion = originalForm.getCurrentFormVersionEntity();
                originalDate = originalFormVersion.getInclusionDate();
            }
            newerFormVersion = draftEntity.get().getForm().getCurrentFormVersionEntity();
            FormEntity newerForm = newerFormVersion.getFormEntity();
            newer = this.formRequirementService.getSInstance(newerForm);
            newerDate = draftEntity.get().getEditionDate();
        } else {
            List<FormVersionEntity> formRequirementEntities = this.requirementService.buscarDuasUltimasVersoesForm(requirementId);
            originalFormVersion = formRequirementEntities.get(1);
            original = this.formRequirementService.getSInstance(originalFormVersion);
            originalDate = originalFormVersion.getInclusionDate();
            newerFormVersion = formRequirementEntities.get(0);
            newer = this.formRequirementService.getSInstance(newerFormVersion);
            newerDate = newerFormVersion.getInclusionDate();
        }
        DocumentDiff diff = DocumentDiffUtil.calculateDiff((SInstance)original, (SInstance)newer).removeUnchangedAndCompact();
        return new DiffSummary(newerFormVersion.getCod(), originalFormVersion != null ? originalFormVersion.getCod() : null, newerDate, originalDate, diff);
    }

    public static class DiffSummary
    implements Serializable {
        private Long currentFormVersionId;
        private Long previousFormVersionId;
        private Date currentFormVersionDate;
        private Date previousFormVersionDate;
        private DocumentDiff diff;

        public DiffSummary(Long currentFormVersionId, Long previousFormVersionId, Date currentFormVersionDate, Date previousFormVersionDate, DocumentDiff diff) {
            this.currentFormVersionId = currentFormVersionId;
            this.previousFormVersionId = previousFormVersionId;
            this.currentFormVersionDate = currentFormVersionDate;
            this.previousFormVersionDate = previousFormVersionDate;
            this.diff = diff;
        }

        public Long getCurrentFormVersionId() {
            return this.currentFormVersionId;
        }

        public Long getPreviousFormVersionId() {
            return this.previousFormVersionId;
        }

        public Date getCurrentFormVersionDate() {
            return this.currentFormVersionDate;
        }

        public Date getPreviousFormVersionDate() {
            return this.previousFormVersionDate;
        }

        public DocumentDiff getDiff() {
            return this.diff;
        }
    }
}

