/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service.attachment;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.opensingular.form.persistence.dao.FormAttachmentDAO;
import org.opensingular.form.persistence.entity.AttachmentContentEntity;
import org.opensingular.form.persistence.entity.AttachmentEntity;
import org.opensingular.form.persistence.entity.FormAttachmentEntity;
import org.opensingular.form.persistence.entity.FormAttachmentEntityId;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.lib.support.persistence.entity.BaseEntity;
import org.opensingular.server.commons.service.attachment.AbstractFormAttachmentService;

@Transactional
public class FormAttachmentService
extends AbstractFormAttachmentService<AttachmentEntity, AttachmentContentEntity, FormAttachmentEntity> {
    @Inject
    private FormAttachmentDAO formAttachmentDAO;

    private FormAttachmentEntity saveNewFormAttachmentEntity(FormAttachmentEntityId formAttachmentPK) {
        if (formAttachmentPK != null) {
            FormAttachmentEntity fae = this.formAttachmentDAO.find((Serializable)formAttachmentPK).orElse(null);
            if (fae == null) {
                fae = new FormAttachmentEntity(formAttachmentPK);
                this.formAttachmentDAO.save((BaseEntity)fae);
            }
            return fae;
        }
        return null;
    }

    @Override
    public void saveNewFormAttachmentEntity(AttachmentEntity attachmentEntity, FormVersionEntity currentFormVersion) {
        this.saveNewFormAttachmentEntity(this.createFormAttachmentEntityId(attachmentEntity, currentFormVersion));
    }

    @Override
    public void deleteFormAttachmentEntity(AttachmentEntity attachmentEntity, FormVersionEntity formVersionEntity) {
        FormAttachmentEntity formAttachmentEntity = this.findFormAttachmentEntity(attachmentEntity, formVersionEntity);
        if (formAttachmentEntity != null) {
            this.formAttachmentDAO.delete(formAttachmentEntity);
        }
    }

    @Override
    public FormAttachmentEntity findFormAttachmentEntity(AttachmentEntity attachmentEntity, FormVersionEntity formVersionEntity) {
        FormAttachmentEntityId formAttachmentPK = this.createFormAttachmentEntityId(attachmentEntity, formVersionEntity);
        if (formAttachmentPK != null) {
            return this.formAttachmentDAO.find((Serializable)formAttachmentPK).orElse(null);
        }
        return null;
    }

    @Override
    public List<FormAttachmentEntity> findAllByVersion(FormVersionEntity formVersionEntity) {
        return this.formAttachmentDAO.findFormAttachmentByFormVersionCod(formVersionEntity.getCod());
    }

    @Override
    public void deleteFormAttachmentEntity(FormAttachmentEntity formAttachmentEntity) {
        this.formAttachmentDAO.delete(formAttachmentEntity);
    }
}

