/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service.attachment;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.opensingular.form.SInstance;
import org.opensingular.form.SInstances;
import org.opensingular.form.document.SDocument;
import org.opensingular.form.persistence.entity.FormAttachmentEntity;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.form.service.IFormService;
import org.opensingular.form.type.core.attachment.IAttachmentPersistenceHandler;
import org.opensingular.form.type.core.attachment.SIAttachment;
import org.opensingular.form.type.core.attachment.helper.DefaultAttachmentPersistenceHelper;
import org.opensingular.server.commons.service.attachment.IFormAttachmentService;

@Transactional
public class ServerAttachmentPersistenceHelper
extends DefaultAttachmentPersistenceHelper {
    @Inject
    private IFormService formService;
    @Inject
    private IFormAttachmentService formAttachmentService;

    @Inject
    public ServerAttachmentPersistenceHelper(IFormService formService, IFormAttachmentService formAttachmentService) {
        this.formService = formService;
        this.formAttachmentService = formAttachmentService;
    }

    public void doPersistence(SDocument document, IAttachmentPersistenceHandler temporaryHandler, IAttachmentPersistenceHandler persistenceHandler) {
        List<FormAttachmentEntity> currentFormAttachmentEntities = this.getCurrentFormAttachmentEntities(document);
        this.findAttachments(document).forEach(attachment -> {
            this.removeFormAttachment(currentFormAttachmentEntities, (SIAttachment)attachment);
            this.handleAttachment((SIAttachment)attachment, temporaryHandler, persistenceHandler);
        });
        currentFormAttachmentEntities.forEach(this.formAttachmentService::deleteFormAttachmentEntity);
    }

    private void removeFormAttachment(List<FormAttachmentEntity> currentFormAttachmentEntities, SIAttachment attachment) {
        currentFormAttachmentEntities.stream().filter(f -> f.getAttachmentEntity().getCod().toString().equals(attachment.getFileId())).findFirst().ifPresent(currentFormAttachmentEntities::remove);
    }

    private List<FormAttachmentEntity> getCurrentFormAttachmentEntities(SDocument document) {
        List<FormAttachmentEntity> result = new ArrayList<FormAttachmentEntity>();
        Optional formVersionEntity = this.formService.findCurrentFormVersion(document);
        if (formVersionEntity.isPresent()) {
            result = this.formAttachmentService.findAllByVersion((FormVersionEntity)formVersionEntity.get());
        }
        return result;
    }

    protected List<SIAttachment> findAttachments(SDocument document) {
        return SInstances.streamDescendants((SInstance)document.getRoot(), (boolean)true).filter(instance -> instance instanceof SIAttachment).map(instance -> (SIAttachment)instance).collect(Collectors.toList());
    }
}

