/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensingular.server.commons.service.dto.BoxDefinitionData;
import org.opensingular.server.commons.service.dto.FormDTO;
import org.opensingular.server.commons.service.dto.ItemBox;
import org.opensingular.server.commons.service.dto.RequirementDefinitionDTO;

public class BoxConfigurationData
implements Serializable {
    private String id;
    private String label;
    private List<BoxDefinitionData> itemBoxesMetadata;
    private List<RequirementDefinitionDTO> processes;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<RequirementDefinitionDTO> getProcesses() {
        return this.processes;
    }

    public void setProcesses(List<RequirementDefinitionDTO> processes) {
        this.processes = processes;
    }

    public List<ItemBox> getItemBoxes() {
        if (this.itemBoxesMetadata == null) {
            return new ArrayList<ItemBox>(0);
        }
        return this.itemBoxesMetadata.stream().map(BoxDefinitionData::getItemBox).collect(Collectors.toList());
    }

    public BoxDefinitionData getItemPorLabel(String itemName) {
        for (BoxDefinitionData itemBoxMeta : this.itemBoxesMetadata) {
            if (!itemBoxMeta.getItemBox().getName().equalsIgnoreCase(itemName)) continue;
            return itemBoxMeta;
        }
        return null;
    }

    public RequirementDefinitionDTO getProcessByAbbreviation(String flowDefinitionAbbreviation) {
        return this.getProcesses().stream().filter(p -> p.getAbbreviation().equalsIgnoreCase(flowDefinitionAbbreviation)).findFirst().orElse(null);
    }

    public List<BoxDefinitionData> getBoxesDefinition() {
        return this.itemBoxesMetadata;
    }

    public void setBoxesDefinition(List<BoxDefinitionData> itemBoxesMetadata) {
        this.itemBoxesMetadata = itemBoxesMetadata;
    }

    @Deprecated
    public List<FormDTO> getForms() {
        return new ArrayList<FormDTO>(0);
    }
}

