/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.service.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import org.opensingular.lib.commons.ui.Icon;
import org.opensingular.server.commons.exception.SingularServerException;
import org.opensingular.server.commons.flow.controllers.IController;
import org.opensingular.server.commons.form.FormAction;
import org.opensingular.server.commons.jackson.IconJsonDeserializer;
import org.opensingular.server.commons.jackson.IconJsonSerializer;
import org.opensingular.server.commons.service.dto.ItemActionConfirmation;
import org.opensingular.server.commons.service.dto.ItemActionType;

public class BoxItemAction
implements Serializable {
    private String endpoint;
    private FormAction formAction;
    private String requirementId;
    private String name;
    private boolean defaultAction;
    private ItemActionConfirmation confirmation;
    private String label;
    private Icon icon;
    private ItemActionType type;
    private String controllerClassName;

    public BoxItemAction() {
    }

    public BoxItemAction(String name, String label, Icon icon, ItemActionType type, String endpoint, Class<? extends IController> controller, ItemActionConfirmation confirmation) {
        this.name = name;
        this.endpoint = endpoint;
        this.label = label;
        this.icon = icon;
        this.type = type;
        this.controllerClassName = controller != null ? controller.getName() : null;
        this.confirmation = confirmation;
    }

    public BoxItemAction(String name, String label, Icon icon, ItemActionType type, FormAction fomAction, String endpoint) {
        this.name = name;
        this.label = label;
        this.icon = icon;
        this.type = type;
        this.formAction = fomAction;
        this.endpoint = endpoint;
        this.defaultAction = false;
    }

    @Deprecated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Deprecated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @JsonIgnore
    public boolean isUseExecute() {
        return ItemActionType.EXECUTE == this.type;
    }

    public FormAction getFormAction() {
        return this.formAction;
    }

    public void setFormAction(FormAction formAction) {
        this.formAction = formAction;
    }

    public String getRequirementId() {
        return this.requirementId;
    }

    public void setRequirementId(String requirementId) {
        this.requirementId = requirementId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(boolean defaultAction) {
        this.defaultAction = defaultAction;
    }

    public ItemActionType getType() {
        return this.type;
    }

    public void setType(ItemActionType type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @JsonSerialize(using=IconJsonSerializer.class)
    public Icon getIcon() {
        return this.icon;
    }

    @JsonDeserialize(using=IconJsonDeserializer.class)
    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public ItemActionConfirmation getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(ItemActionConfirmation confirmation) {
        this.confirmation = confirmation;
    }

    @JsonIgnore
    public Class<IController> getController() {
        try {
            return Class.forName(this.controllerClassName);
        }
        catch (ClassNotFoundException e) {
            throw SingularServerException.rethrow(e.getMessage(), e);
        }
    }

    public String getControllerClassName() {
        return this.controllerClassName;
    }

    public void setControllerClassName(String controllerClassName) {
        this.controllerClassName = controllerClassName;
    }
}

