/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring;

import com.zaxxer.hikari.HikariDataSource;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.persistence.entity.SingularEntityInterceptor;
import org.opensingular.lib.support.persistence.util.SqlUtil;
import org.opensingular.server.commons.exception.SingularServerException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jndi.JndiTemplate;
import org.springframework.orm.hibernate4.HibernateTransactionManager;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement(proxyTargetClass=true)
public class SingularDefaultPersistenceConfiguration
implements Loggable {
    @Value(value="classpath:db/ddl/drops.sql")
    private Resource drops;
    @Value(value="classpath:db/ddl/create-tables-form.sql")
    private Resource sqlCreateTablesForm;
    @Value(value="classpath:db/ddl/create-tables.sql")
    private Resource sqlCreateTables;
    @Value(value="classpath:db/ddl/create-tables-emails.sql")
    private Resource sqlCreateTablesEmail;
    @Value(value="classpath:db/ddl/create-constraints.sql")
    private Resource sqlCreateConstraints;
    @Value(value="classpath:db/ddl/create-constraints-form.sql")
    private Resource sqlCreateConstraintsForm;
    @Value(value="classpath:db/ddl/create-sequences-form.sql")
    private Resource sqlCreateSequencesForm;
    @Value(value="classpath:db/ddl/create-function.sql")
    private Resource sqlCreateFunction;
    @Value(value="classpath:db/ddl/create-tables-actor.sql")
    private Resource sqlCreateTablesActor;
    @Value(value="classpath:db/ddl/create-sequences-server.sql")
    private Resource sqlCreateSequencesServer;
    @Value(value="classpath:db/ddl/create-email-sequences.sql")
    private Resource sqlCreateSequencesEmail;
    @Value(value="classpath:db/dml/insert-flow-data.sql")
    private Resource insertSingularData;

    protected ResourceDatabasePopulator databasePopulator() {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setSqlScriptEncoding(StandardCharsets.UTF_8.name());
        populator.addScript(this.drops);
        populator.addScript(this.sqlCreateTablesForm);
        populator.addScript(this.sqlCreateTables);
        populator.addScript(this.sqlCreateTablesEmail);
        populator.addScript(this.sqlCreateTablesActor);
        populator.addScript(this.sqlCreateSequencesServer);
        populator.addScript(this.sqlCreateSequencesForm);
        populator.addScript(this.sqlCreateSequencesEmail);
        populator.addScript(this.sqlCreateConstraints);
        populator.addScript(this.sqlCreateConstraintsForm);
        populator.addScript(this.insertSingularData);
        return populator;
    }

    @Bean
    public DataSourceInitializer scriptsInitializer(DataSource dataSource) {
        DataSourceInitializer initializer = new DataSourceInitializer();
        initializer.setDataSource(dataSource);
        initializer.setDatabasePopulator((DatabasePopulator)this.databasePopulator());
        initializer.setEnabled(this.isDatabaseInitializerEnabled());
        return initializer;
    }

    @Bean
    @DependsOn(value={"scriptsInitializer"})
    public DataSourceInitializer createFunctionInitializer(DataSource dataSource) {
        DataSourceInitializer initializer = new DataSourceInitializer();
        initializer.setDataSource(dataSource);
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setSeparator("#");
        populator.setSqlScriptEncoding(StandardCharsets.UTF_8.name());
        populator.addScript(this.sqlCreateFunction);
        initializer.setDatabasePopulator((DatabasePopulator)populator);
        initializer.setEnabled(this.isDatabaseInitializerEnabled());
        return initializer;
    }

    @Bean
    public DataSource dataSource() {
        if (SqlUtil.useEmbeddedDatabase()) {
            return this.embeddedDataSourceConfiguration();
        }
        return this.jndiDataSourceConfiguration();
    }

    protected DataSource jndiDataSourceConfiguration() {
        this.getLogger().info("Usando datasource configurado via JNDI");
        DataSource dataSource = null;
        JndiTemplate jndi = new JndiTemplate();
        String dataSourceName = SingularProperties.get((String)"singular.jndi.name.datasource", (String)"java:jboss/datasources/singular");
        try {
            dataSource = (DataSource)jndi.lookup(dataSourceName);
        }
        catch (NamingException e) {
            this.getLogger().error(String.format("Datasource %s not found.", dataSourceName), (Throwable)e);
        }
        return dataSource;
    }

    protected DataSource embeddedDataSourceConfiguration() {
        try {
            this.getLogger().warn("Usando datasource banco embarcado H2");
            HikariDataSource dataSource = new HikariDataSource();
            dataSource.setJdbcUrl(this.getUrlConnection());
            dataSource.setUsername("sa");
            dataSource.setPassword("sa");
            dataSource.setDriverClassName("org.h2.Driver");
            return dataSource;
        }
        catch (Exception e) {
            throw SingularServerException.rethrow(e.getMessage(), e);
        }
    }

    protected String getUrlConnection() {
        return "jdbc:h2:./singularserverdb;AUTO_SERVER=TRUE;mode=ORACLE;CACHE_SIZE=4096;EARLY_FILTER=1;MULTI_THREADED=1;LOCK_TIMEOUT=15000;";
    }

    @DependsOn(value={"createFunctionInitializer"})
    @Bean
    public LocalSessionFactoryBean sessionFactory(DataSource dataSource) {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setHibernateProperties(this.hibernateProperties());
        sessionFactoryBean.setPackagesToScan(this.hibernatePackagesToScan());
        Optional schemaName = SingularProperties.getOpt((String)"singular.custom.schema.name");
        if (schemaName.isPresent()) {
            sessionFactoryBean.setEntityInterceptor((Interceptor)new SingularEntityInterceptor());
            this.getLogger().info("Utilizando schema customizado: {}", schemaName.get());
        }
        return sessionFactoryBean;
    }

    @Bean
    public HibernateTransactionManager transactionManager(SessionFactory sessionFactory, DataSource dataSource) {
        HibernateTransactionManager tx = new HibernateTransactionManager(sessionFactory);
        tx.setDataSource(dataSource);
        return tx;
    }

    protected String[] hibernatePackagesToScan() {
        return new String[]{"org.opensingular.flow.persistence.entity", "org.opensingular.server.commons.persistence.entity", "org.opensingular.app.commons.mail.persistence.entity", "org.opensingular.form.persistence.entity"};
    }

    protected Properties hibernateProperties() {
        Properties hibernateProperties = new Properties();
        hibernateProperties.setProperty("hibernate.dialect", "org.hibernate.dialect.Oracle10gDialect");
        hibernateProperties.setProperty("hibernate.connection.isolation", "2");
        hibernateProperties.setProperty("hibernate.jdbc.batch_size", "30");
        hibernateProperties.setProperty("hibernate.show_sql", "false");
        hibernateProperties.setProperty("hibernate.format_sql", "true");
        hibernateProperties.setProperty("hibernate.enable_lazy_load_no_trans", "true");
        hibernateProperties.setProperty("hibernate.jdbc.use_get_generated_keys", "true");
        hibernateProperties.setProperty("hibernate.cache.use_second_level_cache", "true");
        hibernateProperties.setProperty("hibernate.cache.use_query_cache", "true");
        hibernateProperties.setProperty("net.sf.ehcache.configurationResourceName", "/default-singular-ehcache.xml");
        hibernateProperties.setProperty("hibernate.cache.region.factory_class", "org.hibernate.cache.ehcache.EhCacheRegionFactory");
        return hibernateProperties;
    }

    protected boolean isDatabaseInitializerEnabled() {
        return !SingularProperties.get().isFalse("singular.enabled.h2.inserts");
    }
}

