/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.spring;

import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.wicket.Application;
import org.opensingular.flow.core.SUser;
import org.opensingular.flow.core.service.IUserService;
import org.opensingular.server.commons.persistence.dao.flow.ActorDAO;
import org.opensingular.server.commons.wicket.SingularSession;
import org.springframework.transaction.annotation.Transactional;

public class SingularDefaultUserService
implements IUserService {
    @Inject
    private ActorDAO actorDAO;

    public SUser getUserIfAvailable() {
        String username = null;
        if (Application.exists() && SingularSession.exists()) {
            username = SingularSession.get().getUsername();
        }
        if (username != null) {
            return this.actorDAO.retrieveByUserCod(username);
        }
        return null;
    }

    public boolean canBeAllocated(SUser sUser) {
        return true;
    }

    public SUser findUserByCod(String username) {
        return this.actorDAO.retrieveByUserCod(username);
    }

    @Transactional
    public SUser saveUserIfNeeded(SUser sUser) {
        return this.actorDAO.saveUserIfNeeded(sUser);
    }

    @Transactional
    public Optional<SUser> saveUserIfNeeded(String codUsuario) {
        Objects.requireNonNull(codUsuario);
        return this.actorDAO.saveUserIfNeeded(codUsuario);
    }

    @Transactional
    public SUser findByCod(Integer cod) {
        return this.actorDAO.get(cod).orElse(null);
    }
}

